/*
 * stats.h
 *
 * Copyright (C) 2002 Thomas Graf <tgr@reeler.org>
 *
 * This file belongs to the nstats package, see COPYING for more information.
 *
 */

#ifndef STATS_H_
#define STATS_H_

#include <time.h>

typedef unsigned long long cnt_t;


/*
 * did you ever see such a big struct ? ;)
 */
struct stat_s {

    cnt_t cnt;
    cnt_t bs, bs_rate, bs_old;

    /*
     * ARP
     */
    struct arp_s {

        cnt_t cnt;
        cnt_t bs, bs_rate, bs_old;

    } arp;

    /*
     * RARP
     */
    struct rarp {
        cnt_t cnt;
        cnt_t bs, bs_rate, bs_old;
    } rarp;

    /*
     * Other Layer 3 protocols
     */
    struct other_s {
        cnt_t cnt;
        cnt_t bs, bs_rate, bs_old;
    } other;

    /*
     * Internet Protocol
     */
    struct ip_s {

        cnt_t cnt;
        cnt_t bs, bs_rate, bs_old;

        /*
         * TCP
         */
        struct tcp_s {

            cnt_t cnt;
            cnt_t bs, bs_rate, bs_old;

            /*
             * TCP Options
             */
            struct ipv4_tcp_opts_s {

                cnt_t urg;          cnt_t s_urg;
                cnt_t ack;          cnt_t s_ack;
                cnt_t psh;          cnt_t s_psh;
                cnt_t rst;          cnt_t s_rst;
                cnt_t syn;          cnt_t s_syn;
                cnt_t fin;          cnt_t s_fin;

            } opts;

        } tcp;

        /*
         * UDP
         */
        struct udp_s {

            cnt_t cnt;
            cnt_t bs, bs_rate, bs_old;

        } udp;

        /*
         * Other Layer 4 Protocols
         */
        struct l4_other_s {

            cnt_t cnt;
            cnt_t bs, bs_rate, bs_old;
        
        } other;

        struct tos_s {

            cnt_t none;             cnt_t s_none;
            cnt_t lowdelay;         cnt_t s_lowdelay;
            cnt_t maxthroughput;    cnt_t s_maxthroughput;
            cnt_t reliability;      cnt_t s_reliability;
            cnt_t lowcost;          cnt_t s_lowcost;

        } tos;

        /*
         * IPv4 specific stuff
         */
        struct ipv4_s {

            cnt_t cnt;
            cnt_t bs, bs_rate, bs_old;

            /*
             * ICMP
             */
            struct ipv4_icmp_s {

                cnt_t cnt;
                cnt_t bs, bs_rate, bs_old;

                /*
                 * ICMP Types
                 */
                struct ipv4_icmp_types_s {

                    /*
                     * ICMP destination unreachable
                     */
                    struct ipv4_icmp_types_du_s {

                        cnt_t cnt;
                        cnt_t bs;

                        cnt_t net_unreach;     cnt_t s_net_unreach;
                        cnt_t host_unreach;    cnt_t s_host_unreach;
                        cnt_t prot_unreach;    cnt_t s_prot_unreach;
                        cnt_t frag_needed;     cnt_t s_frag_needed;
                        cnt_t sr_failed;       cnt_t s_sr_failed;
                        cnt_t net_unknown;     cnt_t s_net_unknown;
                        cnt_t host_unknown;    cnt_t s_host_unknown;
                        cnt_t host_isolated;   cnt_t s_host_isolated;
                        cnt_t net_ano;         cnt_t s_net_ano;
                        cnt_t host_ano;        cnt_t s_host_ano;
                        cnt_t net_unr_tos;     cnt_t s_net_unr_tos;
                        cnt_t host_unr_tos;    cnt_t s_host_unr_tos;
                        cnt_t pkt_filtered;    cnt_t s_pkt_filtered;
                        cnt_t prec_violation;  cnt_t s_prec_violation;
                        cnt_t prec_cutoff;     cnt_t s_prec_cutoff;
                        cnt_t other;           cnt_t s_other;

                    } dest_unreach;

                    /*
                     * ICMP redirect
                     */
                    struct ipv4_icmp_types_re_s {
                        cnt_t cnt;
                        cnt_t bs;

                        cnt_t net;          cnt_t s_net;
                        cnt_t host;         cnt_t s_host;
                        cnt_t nettos;       cnt_t s_nettos;
                        cnt_t hosttos;      cnt_t s_hosttos;
                        cnt_t other;        cnt_t s_other;

                    } redirect;

                    /*
                     * ICMP Time Exceeded
                     */
                    struct ipv4_icmp_types_te_s {
                        cnt_t cnt;
                        cnt_t bs;

                        cnt_t ttl;          cnt_t s_ttl;
                        cnt_t fragtime;     cnt_t s_fragtime;
                        cnt_t other;        cnt_t s_other;
                    } time_exceeded;

                    /*
                     * Other ICMP Types
                     */
                    cnt_t echo_reply;       cnt_t s_echo_reply;
                    cnt_t source_quench;    cnt_t s_source_quench;
                    cnt_t echo_request;     cnt_t s_echo_request;
                    cnt_t para_prob;        cnt_t s_para_prob;
                    cnt_t timestamp;        cnt_t s_timestamp;
                    cnt_t timestamp_reply;  cnt_t s_timestamp_reply;
                    cnt_t info_request;     cnt_t s_info_request;
                    cnt_t info_reply;       cnt_t s_info_reply;
                    cnt_t address;          cnt_t s_address;
                    cnt_t address_reply;    cnt_t s_address_reply;
                    cnt_t other;            cnt_t s_other;

                } types;

            } icmp;

        } ipv4;

        /*
         * IPv6 specific stuff
         */
        struct ipv6_s {

            cnt_t cnt;
            cnt_t bs, bs_rate, bs_old;
            cnt_t hoplimit;
            cnt_t tc;              cnt_t s_tc;
            cnt_t fl;              cnt_t s_fl;

            /*
             * ICMP6
             */
            struct ipv6_icmp_s {
                cnt_t cnt;
                cnt_t bs, bs_rate, bs_old;

                /*
                 * ICMP6 destination unreachable
                 */
                struct ipv6_icmp_dst_unreach_s {
                    cnt_t cnt;          cnt_t bs;

                    cnt_t noroute;     cnt_t s_noroute;
                    cnt_t admin;       cnt_t s_admin;
                    cnt_t notneighbor; cnt_t s_notneighbor;
                    cnt_t addr;        cnt_t s_addr;
                    cnt_t noport;      cnt_t s_noport;

                } dst_unreach;

                /*
                 * ICMP6 time exceeded
                 */
                struct ipv6_icmp_time_excd_s {
                    cnt_t cnt;               cnt_t bs;
                    cnt_t transit;       cnt_t s_transit;
                    cnt_t reassembly;;   cnt_t s_reassembly;

                } time_excd;

                /*
                 * ICMP6 parameter problem
                 */
                struct ipv6_icmp_param_prob_s {
                    cnt_t cnt;          cnt_t bs;
                    cnt_t header;         cnt_t s_header;
                    cnt_t nextheader;     cnt_t s_nextheader;
                    cnt_t option;         cnt_t s_option;
                } param_prob;

                /*
                 * Other ICMP6 types
                 */
                cnt_t pkt_too_big;         cnt_t s_pkt_too_big;
                cnt_t echo_request;        cnt_t s_echo_request;
                cnt_t echo_reply;          cnt_t s_echo_reply;
                cnt_t mbrship_query;       cnt_t s_mbrship_query;
                cnt_t mbrship_report;      cnt_t s_mbrship_report;
                cnt_t mbrship_reduction;   cnt_t s_mbrship_reduction;
                cnt_t nd_router_solicit;   cnt_t s_nd_router_solicit;
                cnt_t nd_router_advert;    cnt_t s_nd_router_advert;
                cnt_t nd_neighbor_solicit; cnt_t s_nd_neighbor_solicit;
                cnt_t nd_neighbor_advert;  cnt_t s_nd_neighbor_advert;
                cnt_t nd_redirect;         cnt_t s_nd_redirect;
                cnt_t other;               cnt_t s_other;

            } icmp;

        } ipv6;

        /*
         * ECN
         */
        struct ip_ecn_s {

            cnt_t not_ect;          cnt_t s_not_ect;
            cnt_t ect_0;            cnt_t s_ect_0;
            cnt_t ect_1;            cnt_t s_ect_1;
            cnt_t ce;               cnt_t s_ce;

            cnt_t cwr;              cnt_t s_cwr;
            cnt_t ece;              cnt_t s_ece;
            cnt_t ecn_setup;        cnt_t s_ecn_setup;

        } ecn;

        /*
         * Fragmented packets statistics
         */
        struct ip_frag_s {
            cnt_t frag;   cnt_t s_frag;
            cnt_t nfrag;  cnt_t s_nfrag;
        } frag;


        /*
         * Connection tracking
         */
        struct ip_conn_s {
            unsigned short dport;
            unsigned short sport;

            union {
                struct in_addr ip4;
                struct in6_addr ip6;
            } src_u;

            union {
                struct in_addr ip4;
                struct in6_addr ip6;
            } dst_u;

            char *sname;
            char *dname;

            int type;

            time_t last_activity;

            cnt_t cnt;
            cnt_t bs;

            cnt_t cnt_old;
            cnt_t bs_old;

            unsigned int r_packets;
            unsigned int r_bs;
            unsigned int ratec;

            struct ip_conn_fragment_s {
                unsigned int id;
                cnt_t cnt;
                cnt_t bs;

            } *fragments;

            struct ip_conn_s *next;

        } *conns, *conn_tail;

        /*
         * Port statistics
         */
        struct ip_port_s {
            unsigned short port;
            cnt_t cnt;
            cnt_t bs;
            struct ip_port_s *next;
        } *ports;

        cnt_t c_ports;
    } ip;

    time_t last_rate_refresh;


} stats;

int stats_handle_input(int ch);
void stats_draw(void);
void stats_calc_rate(void);

#endif
