/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.contrib.dnd;

import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.File;
import org.jhotdraw.contrib.dnd.DNDFigures;
import org.jhotdraw.contrib.dnd.DNDFiguresTransferable;
import org.jhotdraw.contrib.dnd.DNDHelper;
import org.jhotdraw.framework.DrawingEditor;
import org.jhotdraw.framework.DrawingView;
import org.jhotdraw.framework.Figure;
import org.jhotdraw.framework.FigureEnumeration;
import org.jhotdraw.standard.DeleteFromDrawingVisitor;
import org.jhotdraw.standard.FigureEnumerator;
import org.jhotdraw.util.Undoable;
import org.jhotdraw.util.UndoableAdapter;

public class JHDDropTargetListener
implements DropTargetListener {
    private int fLastX = 0;
    private int fLastY = 0;
    private Undoable targetUndoable;
    private DrawingView dv;
    private DrawingEditor editor;

    public JHDDropTargetListener(DrawingEditor drawingEditor, DrawingView drawingView) {
        this.dv = drawingView;
        this.editor = drawingEditor;
    }

    protected DrawingView view() {
        return this.dv;
    }

    protected DrawingEditor editor() {
        return this.editor;
    }

    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        JHDDropTargetListener.log("DropTargetDragEvent-dragEnter");
        this.supportDropTargetDragEvent(dropTargetDragEvent);
        if (this.fLastX == 0) {
            this.fLastX = dropTargetDragEvent.getLocation().x;
        }
        if (this.fLastY == 0) {
            this.fLastY = dropTargetDragEvent.getLocation().y;
        }
    }

    public void dragExit(DropTargetEvent dropTargetEvent) {
        JHDDropTargetListener.log("DropTargetEvent-dragExit");
    }

    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        if (this.supportDropTargetDragEvent(dropTargetDragEvent)) {
            int n = dropTargetDragEvent.getLocation().x;
            int n2 = dropTargetDragEvent.getLocation().y;
            if (Math.abs(n - this.fLastX) > 0 || Math.abs(n2 - this.fLastY) > 0) {
                this.fLastX = n;
                this.fLastY = n2;
            }
        }
    }

    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        System.out.println("DropTargetDropEvent-drop");
        if (dropTargetDropEvent.isDataFlavorSupported(DNDFiguresTransferable.DNDFiguresFlavor)) {
            JHDDropTargetListener.log("DNDFiguresFlavor");
            if ((dropTargetDropEvent.getDropAction() & 3) != 0) {
                JHDDropTargetListener.log("copy or move");
                if (!dropTargetDropEvent.isLocalTransfer()) {
                    System.err.println("Intra-JVM Transfers not implemented for figures yet.");
                    dropTargetDropEvent.rejectDrop();
                    return;
                }
                dropTargetDropEvent.acceptDrop(dropTargetDropEvent.getDropAction());
                try {
                    this.setTargetUndoActivity(this.createTargetUndoActivity(this.view()));
                    DNDFigures dNDFigures = (DNDFigures)DNDHelper.processReceivedData(DNDFiguresTransferable.DNDFiguresFlavor, dropTargetDropEvent.getTransferable());
                    this.getTargetUndoActivity().setAffectedFigures(dNDFigures.getFigures());
                    Point point = dNDFigures.getOrigin();
                    this.view().clearSelection();
                    Point point2 = dropTargetDropEvent.getLocation();
                    int n = point2.x - point.x;
                    int n2 = point2.y - point.y;
                    JHDDropTargetListener.log("mouse at " + point2);
                    FigureEnumeration figureEnumeration = this.view().insertFigures(this.getTargetUndoActivity().getAffectedFigures(), n, n2, false);
                    this.getTargetUndoActivity().setAffectedFigures(figureEnumeration);
                    if (dropTargetDropEvent.getDropAction() == 2) {
                        this.view().addToSelectionAll(this.getTargetUndoActivity().getAffectedFigures());
                    }
                    this.view().checkDamage();
                    this.editor().getUndoManager().pushUndo(this.getTargetUndoActivity());
                    this.editor().getUndoManager().clearRedos();
                    this.editor().figureSelectionChanged(this.view());
                    dropTargetDropEvent.dropComplete(true);
                }
                catch (NullPointerException nullPointerException) {
                    nullPointerException.printStackTrace();
                    dropTargetDropEvent.dropComplete(false);
                }
            } else {
                dropTargetDropEvent.rejectDrop();
            }
        } else if (dropTargetDropEvent.isDataFlavorSupported(DataFlavor.stringFlavor)) {
            JHDDropTargetListener.log("String flavor dropped.");
            dropTargetDropEvent.acceptDrop(dropTargetDropEvent.getDropAction());
            Object object = DNDHelper.processReceivedData(DataFlavor.stringFlavor, dropTargetDropEvent.getTransferable());
            if (object != null) {
                JHDDropTargetListener.log("Received string flavored data.");
                dropTargetDropEvent.getDropTargetContext().dropComplete(true);
            } else {
                dropTargetDropEvent.getDropTargetContext().dropComplete(false);
            }
        } else if (dropTargetDropEvent.isDataFlavorSupported(DNDHelper.ASCIIFlavor)) {
            JHDDropTargetListener.log("ASCII Flavor dropped.");
            dropTargetDropEvent.acceptDrop(1);
            Object object = DNDHelper.processReceivedData(DNDHelper.ASCIIFlavor, dropTargetDropEvent.getTransferable());
            if (object != null) {
                JHDDropTargetListener.log("Received ASCII Flavored data.");
                dropTargetDropEvent.getDropTargetContext().dropComplete(true);
            } else {
                dropTargetDropEvent.getDropTargetContext().dropComplete(false);
            }
        } else if (dropTargetDropEvent.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
            JHDDropTargetListener.log("Java File List Flavor dropped.");
            dropTargetDropEvent.acceptDrop(1);
            File[] fileArray = (File[])DNDHelper.processReceivedData(DataFlavor.javaFileListFlavor, dropTargetDropEvent.getTransferable());
            if (fileArray != null) {
                JHDDropTargetListener.log("Got list of files.");
                for (int i = 0; i < fileArray.length; ++i) {
                    System.out.println(fileArray[i].getAbsolutePath());
                }
                dropTargetDropEvent.getDropTargetContext().dropComplete(true);
            } else {
                dropTargetDropEvent.getDropTargetContext().dropComplete(false);
            }
        }
        this.fLastX = 0;
        this.fLastY = 0;
    }

    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
        JHDDropTargetListener.log("DropTargetDragEvent-dropActionChanged");
        this.supportDropTargetDragEvent(dropTargetDragEvent);
    }

    protected boolean supportDropTargetDragEvent(DropTargetDragEvent dropTargetDragEvent) {
        if (dropTargetDragEvent.isDataFlavorSupported(DNDFiguresTransferable.DNDFiguresFlavor)) {
            if ((dropTargetDragEvent.getDropAction() & 3) != 0) {
                dropTargetDragEvent.acceptDrag(dropTargetDragEvent.getDropAction());
                return true;
            }
            dropTargetDragEvent.rejectDrag();
            return false;
        }
        if (dropTargetDragEvent.isDataFlavorSupported(DNDHelper.ASCIIFlavor)) {
            dropTargetDragEvent.acceptDrag(dropTargetDragEvent.getDropAction());
            return true;
        }
        if (dropTargetDragEvent.isDataFlavorSupported(DataFlavor.stringFlavor)) {
            dropTargetDragEvent.acceptDrag(dropTargetDragEvent.getDropAction());
            return true;
        }
        if (dropTargetDragEvent.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
            dropTargetDragEvent.acceptDrag(dropTargetDragEvent.getDropAction());
            return true;
        }
        dropTargetDragEvent.rejectDrag();
        return false;
    }

    protected Undoable createTargetUndoActivity(DrawingView drawingView) {
        return new AddUndoActivity(drawingView);
    }

    protected void setTargetUndoActivity(Undoable undoable) {
        this.targetUndoable = undoable;
    }

    protected Undoable getTargetUndoActivity() {
        return this.targetUndoable;
    }

    private static void log(String string) {
    }

    public static class AddUndoActivity
    extends UndoableAdapter {
        private boolean undone = false;

        public AddUndoActivity(DrawingView drawingView) {
            super(drawingView);
            JHDDropTargetListener.log("AddUndoActivity created " + drawingView);
            this.setUndoable(true);
            this.setRedoable(true);
        }

        public boolean undo() {
            if (!super.undo()) {
                return false;
            }
            JHDDropTargetListener.log("AddUndoActivity AddUndoActivity undo");
            DeleteFromDrawingVisitor deleteFromDrawingVisitor = new DeleteFromDrawingVisitor(this.getDrawingView().drawing());
            FigureEnumeration figureEnumeration = this.getAffectedFigures();
            while (figureEnumeration.hasNextFigure()) {
                Figure figure = figureEnumeration.nextFigure();
                figure.visit(deleteFromDrawingVisitor);
            }
            this.setAffectedFigures(deleteFromDrawingVisitor.getDeletedFigures());
            this.getDrawingView().clearSelection();
            this.undone = true;
            return true;
        }

        public boolean redo() {
            if (!this.isRedoable()) {
                return false;
            }
            JHDDropTargetListener.log("AddUndoActivity redo");
            this.getDrawingView().clearSelection();
            this.setAffectedFigures(this.getDrawingView().insertFigures(this.getAffectedFigures(), 0, 0, false));
            this.undone = false;
            return true;
        }

        public void release() {
            if (this.undone) {
                FigureEnumeration figureEnumeration = this.getAffectedFigures();
                while (figureEnumeration.hasNextFigure()) {
                    Figure figure = figureEnumeration.nextFigure();
                    this.getDrawingView().drawing().remove(figure);
                    figure.release();
                }
            }
            this.setAffectedFigures(FigureEnumerator.getEmptyEnumeration());
        }
    }
}

