/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.contrib.html;

import java.io.IOException;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.jhotdraw.contrib.html.ContentProducer;
import org.jhotdraw.contrib.html.URLContentProducer;
import org.jhotdraw.util.Storable;
import org.jhotdraw.util.StorableInput;
import org.jhotdraw.util.StorableOutput;

public class ContentProducerRegistry
implements Serializable,
Storable {
    private Hashtable fContentProducers = new Hashtable();
    private transient ContentProducerRegistry fParent;
    private static ContentProducerRegistry fDefaultRegistry = new ContentProducerRegistry(null);
    static /* synthetic */ Class class$java$net$URL;

    public ContentProducerRegistry() {
        this.setParent(fDefaultRegistry);
    }

    public ContentProducerRegistry(ContentProducerRegistry contentProducerRegistry) {
        this.setParent(contentProducerRegistry);
    }

    public void setAutonomous() {
        this.setParent(null);
    }

    public boolean isAutonomous() {
        return this.getParent() == null;
    }

    public void setParent(ContentProducerRegistry contentProducerRegistry) {
        this.fParent = contentProducerRegistry;
    }

    public ContentProducerRegistry getParent() {
        return this.fParent;
    }

    public static ContentProducer registerDefaultContentProducer(Class clazz, ContentProducer contentProducer) {
        return fDefaultRegistry.registerContentProducer(clazz, contentProducer);
    }

    public static void unregisterDefaultContentProducer(Class clazz, ContentProducer contentProducer) {
        fDefaultRegistry.unregisterContentProducer(clazz, contentProducer);
    }

    public static ContentProducer getDefaultContentProducer(Class clazz) {
        return fDefaultRegistry.getContentProducer(clazz);
    }

    public static ContentProducer getExactDefaultContentProducer(Class clazz) {
        return fDefaultRegistry.getExactContentProducer(clazz);
    }

    public ContentProducer registerContentProducer(Class clazz, ContentProducer contentProducer) {
        ContentProducer contentProducer2 = this.getContentProducer(clazz);
        this.fContentProducers.put(clazz, contentProducer);
        return contentProducer2;
    }

    public void unregisterContentProducer(Class clazz, ContentProducer contentProducer) {
        ContentProducer contentProducer2 = this.getContentProducer(clazz);
        if (contentProducer2 == contentProducer) {
            this.fContentProducers.remove(clazz);
        }
    }

    public ContentProducer getContentProducer(Class clazz) {
        ContentProducer contentProducer = this.getExactContentProducer(clazz);
        if (contentProducer != null) {
            return contentProducer;
        }
        return this.getSuperClassContentProducer(clazz, null);
    }

    public ContentProducer getExactContentProducer(Class clazz) {
        ContentProducer contentProducer = (ContentProducer)this.fContentProducers.get(clazz);
        if (contentProducer != null) {
            return contentProducer;
        }
        if (!this.isAutonomous()) {
            return this.getParent().getExactContentProducer(clazz);
        }
        return null;
    }

    protected ContentProducer getSuperClassContentProducer(Class clazz, Class clazz2) {
        ContentProducer contentProducer;
        Map.Entry entry = null;
        Class clazz3 = null;
        ContentProducer contentProducer2 = null;
        Iterator iterator = this.fContentProducers.entrySet().iterator();
        while (iterator.hasNext()) {
            entry = iterator.next();
            clazz3 = (Class)entry.getKey();
            if (!clazz3.isAssignableFrom(clazz) || clazz2 == null || !clazz2.isAssignableFrom(clazz3)) continue;
            clazz2 = clazz3;
            contentProducer2 = (ContentProducer)entry.getValue();
        }
        if (!this.isAutonomous() && (contentProducer = this.getParent().getSuperClassContentProducer(clazz, clazz2)) != null) {
            contentProducer2 = contentProducer;
        }
        return contentProducer2;
    }

    public void write(StorableOutput storableOutput) {
        storableOutput.writeInt(this.fContentProducers.size());
        Iterator iterator = this.fContentProducers.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            storableOutput.writeString(((Class)entry.getKey()).getName());
            storableOutput.writeStorable((Storable)entry.getKey());
        }
    }

    public void read(StorableInput storableInput) throws IOException {
        int n = storableInput.readInt();
        for (int i = 0; i < n; ++i) {
            String string = storableInput.readString();
            ContentProducer contentProducer = (ContentProducer)storableInput.readStorable();
            try {
                this.registerContentProducer(Class.forName(string), contentProducer);
                continue;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        fDefaultRegistry.registerContentProducer(class$java$net$URL == null ? (class$java$net$URL = ContentProducerRegistry.class$("java.net.URL")) : class$java$net$URL, new URLContentProducer());
    }
}

