/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.javacpp.indexer;

import org.bytedeco.javacpp.IntPointer;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.indexer.IntIndexer;
import org.bytedeco.javacpp.indexer.Raw;

public class IntRawIndexer
extends IntIndexer {
    protected static final Raw RAW = Raw.getInstance();
    protected IntPointer pointer;
    final long base;
    final long size;

    public IntRawIndexer(IntPointer pointer) {
        this(pointer, new long[]{pointer.limit() - pointer.position()}, ONE_STRIDE);
    }

    public IntRawIndexer(IntPointer pointer, long[] sizes, long[] strides) {
        super(sizes, strides);
        this.pointer = pointer;
        this.base = pointer.address() + pointer.position() * 4L;
        this.size = pointer.limit() - pointer.position();
    }

    @Override
    public Pointer pointer() {
        return this.pointer;
    }

    @Override
    public int get(long i) {
        return RAW.getInt(this.base + IntRawIndexer.checkIndex(i, this.size) * 4L);
    }

    @Override
    public IntIndexer get(long i, int[] m, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            m[offset + n] = this.get(i * this.strides[0] + (long)n);
        }
        return this;
    }

    @Override
    public int get(long i, long j) {
        return this.get(i * this.strides[0] + j);
    }

    @Override
    public IntIndexer get(long i, long j, int[] m, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            m[offset + n] = this.get(i * this.strides[0] + j * this.strides[1] + (long)n);
        }
        return this;
    }

    @Override
    public int get(long i, long j, long k) {
        return this.get(i * this.strides[0] + j * this.strides[1] + k);
    }

    @Override
    public int get(long ... indices) {
        return this.get(this.index(indices));
    }

    @Override
    public IntIndexer get(long[] indices, int[] m, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            m[offset + n] = this.get(this.index(indices) + (long)n);
        }
        return this;
    }

    @Override
    public IntIndexer put(long i, int n) {
        RAW.putInt(this.base + IntRawIndexer.checkIndex(i, this.size) * 4L, n);
        return this;
    }

    @Override
    public IntIndexer put(long i, int[] m, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            this.put(i * this.strides[0] + (long)n, m[offset + n]);
        }
        return this;
    }

    @Override
    public IntIndexer put(long i, long j, int n) {
        this.put(i * this.strides[0] + j, n);
        return this;
    }

    @Override
    public IntIndexer put(long i, long j, int[] m, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            this.put(i * this.strides[0] + j * this.strides[1] + (long)n, m[offset + n]);
        }
        return this;
    }

    @Override
    public IntIndexer put(long i, long j, long k, int n) {
        this.put(i * this.strides[0] + j * this.strides[1] + k, n);
        return this;
    }

    @Override
    public IntIndexer put(long[] indices, int n) {
        this.put(this.index(indices), n);
        return this;
    }

    @Override
    public IntIndexer put(long[] indices, int[] m, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            this.put(this.index(indices) + (long)n, m[offset + n]);
        }
        return this;
    }

    @Override
    public void release() {
        this.pointer = null;
    }
}

