/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.internal;

import com.vladsch.flexmark.ast.Text;
import com.vladsch.flexmark.internal.Delimiter;
import com.vladsch.flexmark.util.sequence.BasedSequence;

public class Bracket {
    final Text node;
    final int index;
    final boolean image;
    final BasedSequence input;
    final Bracket previous;
    final Delimiter previousDelimiter;
    boolean allowed = true;
    boolean bracketAfter = false;

    int getStartIndex() {
        return this.index;
    }

    int getEndIndex() {
        return this.image ? this.index + 2 : this.index + 1;
    }

    static Bracket link(BasedSequence input, Text node, int index, Bracket previous, Delimiter previousDelimiter) {
        return new Bracket(input, node, index, previous, previousDelimiter, false);
    }

    static Bracket image(BasedSequence input, Text node, int index, Bracket previous, Delimiter previousDelimiter) {
        return new Bracket(input, node, index, previous, previousDelimiter, true);
    }

    private Bracket(BasedSequence input, Text node, int index, Bracket previous, Delimiter previousDelimiter, boolean image) {
        this.node = node;
        this.index = index;
        this.image = image;
        this.previous = previous;
        this.previousDelimiter = previousDelimiter;
        this.input = input;
    }

    public boolean isStraddling(BasedSequence nodeChars) {
        int innerOffset;
        Delimiter inner;
        int startOffset = nodeChars.getStartOffset();
        int endOffset = nodeChars.getEndOffset();
        Delimiter delimiter = inner = this.previousDelimiter == null ? null : this.previousDelimiter.next;
        while (inner != null && (innerOffset = inner.getEndIndex()) < endOffset) {
            if (innerOffset >= startOffset && !inner.matched) {
                return true;
            }
            inner = inner.next;
        }
        return false;
    }
}

