/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ast;

import com.vladsch.flexmark.ast.Node;
import com.vladsch.flexmark.util.collection.Consumer;
import com.vladsch.flexmark.util.collection.iteration.ReversiblePeekingIterator;
import java.util.Stack;

public class DescendantNodeIterator
implements ReversiblePeekingIterator<Node> {
    private final boolean isReversed;
    private ReversiblePeekingIterator<Node> iterator;
    private Stack<ReversiblePeekingIterator<Node>> iteratorStack;
    private Node result;

    public DescendantNodeIterator(ReversiblePeekingIterator<Node> iterator) {
        this.isReversed = iterator.isReversed();
        this.iterator = iterator instanceof DescendantNodeIterator ? ((DescendantNodeIterator)iterator).iterator : iterator;
        this.iteratorStack = null;
        this.result = null;
    }

    @Override
    public boolean isReversed() {
        return this.isReversed;
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    public Node next() {
        this.result = (Node)this.iterator.next();
        if (this.result.getFirstChild() != null) {
            if (this.iterator.hasNext()) {
                if (this.iteratorStack == null) {
                    this.iteratorStack = new Stack();
                }
                this.iteratorStack.push(this.iterator);
            }
            this.iterator = this.isReversed ? this.result.getReversedChildIterator() : this.result.getChildIterator();
        } else if (this.iteratorStack != null && !this.iteratorStack.isEmpty() && !this.iterator.hasNext()) {
            this.iterator = this.iteratorStack.pop();
        }
        return this.result;
    }

    @Override
    public Node peek() {
        return this.iterator.peek();
    }

    @Override
    public void remove() {
        if (this.result == null) {
            throw new IllegalStateException("Either next() was not called yet or the node was removed");
        }
        this.result.unlink();
        this.result = null;
    }

    @Override
    public void forEachRemaining(Consumer<? super Node> consumer) {
        if (consumer == null) {
            throw new NullPointerException();
        }
        while (this.hasNext()) {
            consumer.accept(this.next());
        }
    }
}

