/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.util.collection;

import com.vladsch.flexmark.ast.Node;
import com.vladsch.flexmark.util.Computable;
import com.vladsch.flexmark.util.collection.ClassificationBag;
import com.vladsch.flexmark.util.collection.SubClassingBag;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class NodeCollectingVisitor {
    public static final Computable<Class, Node> NODE_CLASSIFIER = new Computable<Class, Node>(){

        @Override
        public Class compute(Node value) {
            return value.getClass();
        }
    };
    private final HashMap<Class, List<Class>> mySubClassMap;
    private final HashSet<Class> myIncluded;
    private final HashSet<Class> myExcluded;
    private final ClassificationBag<Class, Node> myNodes;
    private final Class[] myClasses;

    public NodeCollectingVisitor(Set<Class> classes) {
        this.myClasses = classes.toArray(new Class[classes.size()]);
        this.mySubClassMap = new HashMap();
        this.myIncluded = new HashSet();
        this.myIncluded.addAll(classes);
        for (Class clazz : classes) {
            ArrayList<Class> classList = new ArrayList<Class>(1);
            classList.add(clazz);
            this.mySubClassMap.put(clazz, classList);
        }
        this.myExcluded = new HashSet();
        this.myNodes = new ClassificationBag<Class, Node>(NODE_CLASSIFIER);
    }

    public void collect(Node node) {
        this.visit(node);
    }

    public SubClassingBag<Node> getSubClassingBag() {
        return new SubClassingBag<Node>(this.myNodes, this.mySubClassMap);
    }

    private void visit(Node node) {
        Class<?> nodeClass = node.getClass();
        if (this.myIncluded.contains(nodeClass)) {
            this.myNodes.add(node);
        } else if (!this.myExcluded.contains(nodeClass)) {
            for (Class clazz : this.myClasses) {
                if (!clazz.isInstance(node)) continue;
                this.myIncluded.add(nodeClass);
                List<Class> classList = this.mySubClassMap.get(clazz);
                if (classList == null) {
                    classList = new ArrayList<Class>(2);
                    classList.add(clazz);
                    classList.add(nodeClass);
                    this.mySubClassMap.put(clazz, classList);
                } else {
                    classList.add(nodeClass);
                }
                this.myNodes.add(node);
                this.visitChildren(node);
                return;
            }
            this.myExcluded.add(nodeClass);
        }
        this.visitChildren(node);
    }

    private void visitChildren(Node parent) {
        Node node = parent.getFirstChild();
        while (node != null) {
            Node next = node.getNext();
            this.visit(node);
            node = next;
        }
    }
}

