/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene;

import com.sun.javafx.scene.CameraHelper;
import com.sun.javafx.scene.NodeHelper;
import com.sun.javafx.scene.SceneHelper;
import com.sun.javafx.scene.SubSceneHelper;
import javafx.geometry.Point2D;
import javafx.geometry.Point3D;
import javafx.scene.SubScene;

public class SceneUtils {
    public static Point3D subSceneToScene(SubScene subScene, Point3D point) {
        SubScene n = subScene;
        while (n != null) {
            Point2D projection = CameraHelper.project(SubSceneHelper.getEffectiveCamera(subScene), point);
            point = n.localToScene(projection.getX(), projection.getY(), 0.0);
            n = NodeHelper.getSubScene(n);
        }
        return point;
    }

    public static Point2D sceneToSubScenePlane(SubScene subScene, Point2D point) {
        point = SceneUtils.computeSubSceneCoordinates(point.getX(), point.getY(), subScene);
        return point;
    }

    private static Point2D computeSubSceneCoordinates(double x, double y, SubScene subScene) {
        SubScene outer = NodeHelper.getSubScene(subScene);
        if (outer == null) {
            return CameraHelper.pickNodeXYPlane(SceneHelper.getEffectiveCamera(subScene.getScene()), subScene, x, y);
        }
        Point2D coords = SceneUtils.computeSubSceneCoordinates(x, y, outer);
        if (coords != null) {
            coords = CameraHelper.pickNodeXYPlane(SubSceneHelper.getEffectiveCamera(outer), subScene, coords.getX(), coords.getY());
        }
        return coords;
    }
}

