/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.text;

import com.sun.javafx.font.FontResource;
import com.sun.javafx.font.FontStrike;
import com.sun.javafx.font.PGFont;
import com.sun.javafx.font.PrismFontFactory;
import com.sun.javafx.scene.text.TextSpan;
import com.sun.javafx.text.PrismTextLayout;
import com.sun.javafx.text.ScriptMapper;
import com.sun.javafx.text.TextRun;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.Bidi;

public abstract class GlyphLayout {
    public static final int CANONICAL_SUBSTITUTION = 0x40000000;
    public static final int LAYOUT_LEFT_TO_RIGHT = 1;
    public static final int LAYOUT_RIGHT_TO_LEFT = 2;
    public static final int LAYOUT_NO_START_CONTEXT = 4;
    public static final int LAYOUT_NO_LIMIT_CONTEXT = 8;
    public static final int HINTING = 16;
    private static Method isIdeographicMethod = null;
    private static GlyphLayout reusableGL;
    private static boolean inUse;

    protected TextRun addTextRun(PrismTextLayout layout, char[] chars, int start, int length, PGFont font, TextSpan span, byte level) {
        TextRun run = new TextRun(start, length, level, true, 0, span, 0, false);
        layout.addTextRun(run);
        return run;
    }

    private TextRun addTextRun(PrismTextLayout layout, char[] chars, int start, int length, PGFont font, TextSpan span, byte level, boolean complex) {
        if (complex || (level & 1) != 0) {
            return this.addTextRun(layout, chars, start, length, font, span, level);
        }
        TextRun run = new TextRun(start, length, level, false, 0, span, 0, false);
        layout.addTextRun(run);
        return run;
    }

    public int breakRuns(PrismTextLayout layout, char[] chars, int flags) {
        int length = chars.length;
        boolean complex = false;
        boolean feature = false;
        int scriptRun = 0;
        int script = 0;
        boolean checkComplex = true;
        boolean checkBidi = true;
        if ((flags & 2) != 0) {
            checkComplex = (flags & 0x10) != 0;
            checkBidi = (flags & 8) != 0;
        }
        TextRun run = null;
        Bidi bidi = null;
        byte bidiLevel = 0;
        int bidiEnd = length;
        int bidiIndex = 0;
        int spanIndex = 0;
        TextSpan span = null;
        int spanEnd = length;
        PGFont font = null;
        TextSpan[] spans = layout.getTextSpans();
        if (spans != null) {
            if (spans.length > 0) {
                span = spans[spanIndex];
                spanEnd = span.getText().length();
                font = (PGFont)span.getFont();
                if (font == null) {
                    flags |= 0x20;
                }
            }
        } else {
            font = layout.getFont();
        }
        if (font != null) {
            int supportedFeatures;
            FontResource fr = font.getFontResource();
            int requestedFeatures = font.getFeatures();
            boolean bl = feature = (requestedFeatures & (supportedFeatures = fr.getFeatures())) != 0;
        }
        if (checkBidi && length > 0) {
            int direction = layout.getDirection();
            bidi = new Bidi(chars, 0, null, 0, length, direction);
            bidiLevel = (byte)bidi.getLevelAt(bidi.getRunStart(bidiIndex));
            bidiEnd = bidi.getRunLimit(bidiIndex);
            if ((bidiLevel & 1) != 0) {
                flags |= 0x18;
            }
        }
        int start = 0;
        int i = 0;
        while (i < length) {
            boolean delimiter;
            int ch;
            int codePoint = ch = chars[i];
            boolean bl = delimiter = ch == 9 || ch == 10 || ch == 13;
            if (delimiter && i != start) {
                run = this.addTextRun(layout, chars, start, i - start, font, span, bidiLevel, complex);
                if (complex) {
                    flags |= 0x10;
                    complex = false;
                }
                start = i;
            }
            boolean spanChanged = i >= spanEnd && i < length;
            boolean levelChanged = i >= bidiEnd && i < length;
            boolean scriptChanged = false;
            if (!delimiter) {
                boolean oldComplex = complex;
                if (checkComplex) {
                    if (Character.isHighSurrogate((char)ch) && i + 1 < spanEnd && Character.isLowSurrogate(chars[i + 1])) {
                        codePoint = Character.toCodePoint((char)ch, chars[++i]);
                    }
                    if (GlyphLayout.isIdeographic(codePoint)) {
                        flags |= 0x40;
                    }
                    script = ScriptMapper.getScript(codePoint);
                    if (scriptRun > 1 && script > 1 && script != scriptRun) {
                        scriptChanged = true;
                    }
                    if (!complex) {
                        boolean bl2 = complex = feature || ScriptMapper.isComplexCharCode(codePoint);
                    }
                }
                if ((spanChanged || levelChanged || scriptChanged) && start != i) {
                    run = this.addTextRun(layout, chars, start, i - start, font, span, bidiLevel, oldComplex);
                    if (complex) {
                        flags |= 0x10;
                        complex = false;
                    }
                    start = i;
                }
                ++i;
            }
            if (spanChanged) {
                span = spans[++spanIndex];
                spanEnd += span.getText().length();
                font = (PGFont)span.getFont();
                if (font == null) {
                    flags |= 0x20;
                } else {
                    int supportedFeatures;
                    FontResource fr = font.getFontResource();
                    int requestedFeatures = font.getFeatures();
                    boolean bl3 = feature = (requestedFeatures & (supportedFeatures = fr.getFeatures())) != 0;
                }
            }
            if (levelChanged) {
                bidiLevel = (byte)bidi.getLevelAt(bidi.getRunStart(++bidiIndex));
                bidiEnd = bidi.getRunLimit(bidiIndex);
                if ((bidiLevel & 1) != 0) {
                    flags |= 0x18;
                }
            }
            if (scriptChanged) {
                scriptRun = script;
            }
            if (!delimiter) continue;
            if (ch == 13 && ++i < spanEnd && chars[i] == '\n') {
                ++i;
            }
            run = new TextRun(start, i - start, bidiLevel, false, 0, span, 0, false);
            if (ch == 9) {
                run.setTab();
                flags |= 4;
            } else {
                run.setLinebreak();
            }
            layout.addTextRun(run);
            start = i;
        }
        if (start < length) {
            this.addTextRun(layout, chars, start, length - start, font, span, bidiLevel, complex);
            if (complex) {
                flags |= 0x10;
            }
        } else if (run == null || run.isLinebreak()) {
            run = new TextRun(start, 0, 0, false, 0, span, 0, false);
            layout.addTextRun(run);
        }
        if (bidi != null && !bidi.baseIsLeftToRight()) {
            flags |= 0x100;
        }
        return flags |= 2;
    }

    public abstract void layout(TextRun var1, PGFont var2, FontStrike var3, char[] var4);

    protected int getInitialSlot(FontResource fr) {
        if (PrismFontFactory.isJreFont(fr)) {
            if (PrismFontFactory.debugFonts) {
                System.err.println("Avoiding JRE Font: " + fr.getFullName());
            }
            return 1;
        }
        return 0;
    }

    private static GlyphLayout newInstance() {
        PrismFontFactory factory = PrismFontFactory.getFontFactory();
        return factory.createGlyphLayout();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GlyphLayout getInstance() {
        if (inUse) {
            return GlyphLayout.newInstance();
        }
        Class<GlyphLayout> clazz = GlyphLayout.class;
        synchronized (GlyphLayout.class) {
            if (inUse) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return GlyphLayout.newInstance();
            }
            inUse = true;
            // ** MonitorExit[var0] (shouldn't be in output)
            return reusableGL;
        }
    }

    public void dispose() {
        if (this == reusableGL) {
            inUse = false;
        }
    }

    private static boolean isIdeographic(int codePoint) {
        if (isIdeographicMethod != null) {
            try {
                return (Boolean)isIdeographicMethod.invoke(null, codePoint);
            }
            catch (IllegalAccessException | InvocationTargetException ex) {
                return false;
            }
        }
        return false;
    }

    static {
        try {
            isIdeographicMethod = Character.class.getMethod("isIdeographic", Integer.TYPE);
        }
        catch (NoSuchMethodException | SecurityException e) {
            isIdeographicMethod = null;
        }
        reusableGL = GlyphLayout.newInstance();
    }
}

