/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prism.j2d;

import com.sun.glass.ui.Screen;
import com.sun.javafx.image.impl.IntArgbPre;
import com.sun.prism.Graphics;
import com.sun.prism.Image;
import com.sun.prism.PixelFormat;
import com.sun.prism.RTTexture;
import com.sun.prism.Texture;
import com.sun.prism.j2d.J2DPresentable;
import com.sun.prism.j2d.J2DResourceFactory;
import com.sun.prism.j2d.J2DTexture;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferInt;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;

class J2DRTTexture
extends J2DTexture
implements RTTexture {
    protected J2DResourceFactory factory;
    private boolean opaque;

    J2DRTTexture(int w, int h, J2DResourceFactory factory) {
        super(new BufferedImage(w, h, 3), PixelFormat.INT_ARGB_PRE, IntArgbPre.setter, Texture.WrapMode.CLAMP_TO_ZERO);
        this.factory = factory;
        this.opaque = false;
    }

    @Override
    public int[] getPixels() {
        BufferedImage bimg = this.getBufferedImage();
        DataBuffer db = bimg.getRaster().getDataBuffer();
        if (db instanceof DataBufferInt) {
            return ((DataBufferInt)db).getData();
        }
        return null;
    }

    @Override
    public boolean readPixels(Buffer pixels, int x, int y, int width, int height) {
        if (x != this.getContentX() || y != this.getContentY() || width != this.getContentWidth() || height != this.getContentHeight()) {
            throw new IllegalArgumentException("reading subtexture not yet supported!");
        }
        return this.readPixels(pixels);
    }

    @Override
    public boolean readPixels(Buffer pixels) {
        int w = this.getContentWidth();
        int h = this.getContentHeight();
        int[] pixbuf = this.getPixels();
        pixels.clear();
        for (int i = 0; i < w * h; ++i) {
            int argb = pixbuf[i];
            if (pixels instanceof IntBuffer) {
                ((IntBuffer)pixels).put(argb);
                continue;
            }
            if (!(pixels instanceof ByteBuffer)) continue;
            byte a = (byte)(argb >> 24);
            byte r = (byte)(argb >> 16);
            byte g = (byte)(argb >> 8);
            byte b = (byte)argb;
            ((ByteBuffer)pixels).put(b);
            ((ByteBuffer)pixels).put(g);
            ((ByteBuffer)pixels).put(r);
            ((ByteBuffer)pixels).put(a);
        }
        pixels.rewind();
        return true;
    }

    @Override
    public Graphics createGraphics() {
        BufferedImage bimg = this.getBufferedImage();
        J2DPresentable presentable = J2DPresentable.create(bimg, this.factory);
        Graphics2D g2d = bimg.createGraphics();
        return this.factory.createJ2DPrismGraphics(presentable, g2d);
    }

    Graphics2D createAWTGraphics2D() {
        return this.getBufferedImage().createGraphics();
    }

    @Override
    public Screen getAssociatedScreen() {
        return this.factory.getScreen();
    }

    @Override
    public void update(Image img) {
        throw new UnsupportedOperationException("update() not supported for RTTextures");
    }

    @Override
    public void update(Image img, int dstx, int dsty) {
        throw new UnsupportedOperationException("update() not supported for RTTextures");
    }

    @Override
    public void update(Image img, int dstx, int dsty, int w, int h) {
        throw new UnsupportedOperationException("update() not supported for RTTextures");
    }

    @Override
    public void update(Image img, int dstx, int dsty, int srcw, int srch, boolean skipFlush) {
        throw new UnsupportedOperationException("update() not supported for RTTextures");
    }

    @Override
    public void update(Buffer buffer, PixelFormat format, int dstx, int dsty, int srcx, int srcy, int srcw, int srch, int srcscan, boolean skipFlush) {
        throw new UnsupportedOperationException("update() not supported for RTTextures");
    }

    @Override
    public boolean isOpaque() {
        return this.opaque;
    }

    @Override
    public void setOpaque(boolean opaque) {
        this.opaque = opaque;
    }

    @Override
    public boolean isVolatile() {
        return false;
    }

    @Override
    public boolean isMSAA() {
        return false;
    }
}

