/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scenario.effect.impl;

import com.sun.javafx.geom.Rectangle;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.geom.transform.NoninvertibleTransformException;
import com.sun.scenario.effect.Effect;
import com.sun.scenario.effect.FilterContext;
import com.sun.scenario.effect.ImageData;
import com.sun.scenario.effect.impl.Renderer;
import com.sun.scenario.effect.impl.state.RenderState;

public abstract class EffectPeer<T extends RenderState> {
    private final FilterContext fctx;
    private final Renderer renderer;
    private final String uniqueName;
    private Effect effect;
    private T renderState;
    private int pass;
    private final Rectangle[] inputBounds = new Rectangle[2];
    private final BaseTransform[] inputTransforms = new BaseTransform[2];
    private final Rectangle[] inputNativeBounds = new Rectangle[2];
    private Rectangle destBounds;
    private final Rectangle destNativeBounds = new Rectangle();

    protected EffectPeer(FilterContext fctx, Renderer renderer, String uniqueName) {
        if (fctx == null) {
            throw new IllegalArgumentException("FilterContext must be non-null");
        }
        this.fctx = fctx;
        this.renderer = renderer;
        this.uniqueName = uniqueName;
    }

    public boolean isImageDataCompatible(ImageData id) {
        return this.getRenderer().isImageDataCompatible(id);
    }

    public abstract ImageData filter(Effect var1, T var2, BaseTransform var3, Rectangle var4, ImageData ... var5);

    public void dispose() {
    }

    public Effect.AccelType getAccelType() {
        return this.renderer.getAccelType();
    }

    protected final FilterContext getFilterContext() {
        return this.fctx;
    }

    protected Renderer getRenderer() {
        return this.renderer;
    }

    public String getUniqueName() {
        return this.uniqueName;
    }

    protected Effect getEffect() {
        return this.effect;
    }

    protected void setEffect(Effect effect) {
        this.effect = effect;
    }

    protected T getRenderState() {
        return this.renderState;
    }

    protected void setRenderState(T renderState) {
        this.renderState = renderState;
    }

    public final int getPass() {
        return this.pass;
    }

    public void setPass(int pass) {
        this.pass = pass;
    }

    protected final Rectangle getInputBounds(int inputIndex) {
        return this.inputBounds[inputIndex];
    }

    protected final void setInputBounds(int inputIndex, Rectangle r) {
        this.inputBounds[inputIndex] = r;
    }

    protected final BaseTransform getInputTransform(int inputIndex) {
        return this.inputTransforms[inputIndex];
    }

    protected final void setInputTransform(int inputIndex, BaseTransform tx) {
        this.inputTransforms[inputIndex] = tx;
    }

    protected final Rectangle getInputNativeBounds(int inputIndex) {
        return this.inputNativeBounds[inputIndex];
    }

    protected final void setInputNativeBounds(int inputIndex, Rectangle r) {
        this.inputNativeBounds[inputIndex] = r;
    }

    public Rectangle getResultBounds(BaseTransform transform, Rectangle outputClip, ImageData ... inputDatas) {
        return this.getEffect().getResultBounds(transform, outputClip, inputDatas);
    }

    protected float[] getSourceRegion(int inputIndex) {
        return EffectPeer.getSourceRegion(this.getInputBounds(inputIndex), this.getInputNativeBounds(inputIndex), this.getDestBounds());
    }

    static float[] getSourceRegion(Rectangle srcBounds, Rectangle srcNativeBounds, Rectangle dstBounds) {
        float x1 = dstBounds.x - srcBounds.x;
        float y1 = dstBounds.y - srcBounds.y;
        float x2 = x1 + (float)dstBounds.width;
        float y2 = y1 + (float)dstBounds.height;
        float sw = srcNativeBounds.width;
        float sh = srcNativeBounds.height;
        return new float[]{x1 / sw, y1 / sh, x2 / sw, y2 / sh};
    }

    public int getTextureCoordinates(int inputIndex, float[] coords, float srcX, float srcY, float srcNativeWidth, float srcNativeHeight, Rectangle dstBounds, BaseTransform transform) {
        return EffectPeer.getTextureCoordinates(coords, srcX, srcY, srcNativeWidth, srcNativeHeight, dstBounds, transform);
    }

    public static int getTextureCoordinates(float[] coords, float srcX, float srcY, float srcNativeWidth, float srcNativeHeight, Rectangle dstBounds, BaseTransform transform) {
        int numCoords;
        coords[0] = dstBounds.x;
        coords[1] = dstBounds.y;
        coords[2] = coords[0] + (float)dstBounds.width;
        coords[3] = coords[1] + (float)dstBounds.height;
        if (transform.isTranslateOrIdentity()) {
            srcX += (float)transform.getMxt();
            srcY += (float)transform.getMyt();
            numCoords = 4;
        } else {
            coords[4] = coords[2];
            coords[5] = coords[1];
            coords[6] = coords[0];
            coords[7] = coords[3];
            numCoords = 8;
            try {
                transform.inverseTransform(coords, 0, coords, 0, 4);
            }
            catch (NoninvertibleTransformException e) {
                coords[4] = 0.0f;
                coords[2] = 0.0f;
                coords[1] = 0.0f;
                coords[0] = 0.0f;
                return 4;
            }
        }
        for (int i = 0; i < numCoords; i += 2) {
            coords[i] = (coords[i] - srcX) / srcNativeWidth;
            coords[i + 1] = (coords[i + 1] - srcY) / srcNativeHeight;
        }
        return numCoords;
    }

    protected final void setDestBounds(Rectangle r) {
        this.destBounds = r;
    }

    protected final Rectangle getDestBounds() {
        return this.destBounds;
    }

    protected final Rectangle getDestNativeBounds() {
        return this.destNativeBounds;
    }

    protected final void setDestNativeBounds(int w, int h) {
        this.destNativeBounds.width = w;
        this.destNativeBounds.height = h;
    }

    protected Object getSamplerData(int i) {
        return null;
    }

    protected boolean isOriginUpperLeft() {
        return this.getAccelType() != Effect.AccelType.OPENGL;
    }
}

