/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scenario.effect.impl.state;

import com.sun.javafx.geom.Rectangle;
import com.sun.javafx.geom.transform.Affine2D;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.geom.transform.NoninvertibleTransformException;
import com.sun.scenario.effect.Color4f;
import com.sun.scenario.effect.Filterable;
import com.sun.scenario.effect.ImageData;
import com.sun.scenario.effect.impl.BufferUtil;
import com.sun.scenario.effect.impl.state.LinearConvolveRenderState;
import com.sun.scenario.effect.impl.state.RenderState;
import java.nio.FloatBuffer;

public class GaussianRenderState
extends LinearConvolveRenderState {
    public static final float MAX_RADIUS = (MAX_KERNEL_SIZE - 1) / 2;
    private boolean isShadow;
    private Color4f shadowColor;
    private float spread;
    private RenderState.EffectCoordinateSpace space;
    private BaseTransform inputtx;
    private BaseTransform resulttx;
    private float inputRadiusX;
    private float inputRadiusY;
    private float spreadPass;
    private int validatedPass;
    private LinearConvolveRenderState.PassType passType;
    private float passRadius;
    private FloatBuffer weights;
    private float[] samplevectors;
    private float weightsValidRadius;
    private float weightsValidSpread;

    static FloatBuffer getGaussianWeights(FloatBuffer weights, int pad, float radius, float spread) {
        int r = pad;
        int klen = r * 2 + 1;
        if (weights == null) {
            weights = BufferUtil.newFloatBuffer(128);
        }
        weights.clear();
        float sigma = radius / 3.0f;
        float sigma22 = 2.0f * sigma * sigma;
        if (sigma22 < Float.MIN_VALUE) {
            sigma22 = Float.MIN_VALUE;
        }
        float total = 0.0f;
        for (int row = -r; row <= r; ++row) {
            float kval = (float)Math.exp((float)(-(row * row)) / sigma22);
            weights.put(kval);
            total += kval;
        }
        total += (weights.get(0) - total) * spread;
        for (int i = 0; i < klen; ++i) {
            weights.put(i, weights.get(i) / total);
        }
        int limit = GaussianRenderState.getPeerSize(klen);
        while (weights.position() < limit) {
            weights.put(0.0f);
        }
        weights.limit(limit);
        weights.rewind();
        return weights;
    }

    public GaussianRenderState(float xradius, float yradius, float spread, boolean isShadow, Color4f shadowColor, BaseTransform filtertx) {
        this.isShadow = isShadow;
        this.shadowColor = shadowColor;
        this.spread = spread;
        if (filtertx == null) {
            filtertx = BaseTransform.IDENTITY_TRANSFORM;
        }
        double mxx = filtertx.getMxx();
        double mxy = filtertx.getMxy();
        double myx = filtertx.getMyx();
        double myy = filtertx.getMyy();
        double txScaleX = Math.hypot(mxx, myx);
        double txScaleY = Math.hypot(mxy, myy);
        boolean scaled = false;
        float scaledRadiusX = (float)((double)xradius * txScaleX);
        float scaledRadiusY = (float)((double)yradius * txScaleY);
        if (scaledRadiusX < 0.00390625f && scaledRadiusY < 0.00390625f) {
            this.inputRadiusX = 0.0f;
            this.inputRadiusY = 0.0f;
            this.spreadPass = 0.0f;
            this.space = RenderState.EffectCoordinateSpace.RenderSpace;
            this.inputtx = filtertx;
            this.resulttx = BaseTransform.IDENTITY_TRANSFORM;
            this.samplevectors = new float[]{1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f};
        } else {
            if (scaledRadiusX > MAX_RADIUS) {
                scaledRadiusX = MAX_RADIUS;
                txScaleX = MAX_RADIUS / xradius;
                scaled = true;
            }
            if (scaledRadiusY > MAX_RADIUS) {
                scaledRadiusY = MAX_RADIUS;
                txScaleY = MAX_RADIUS / yradius;
                scaled = true;
            }
            this.inputRadiusX = scaledRadiusX;
            this.inputRadiusY = scaledRadiusY;
            float f = this.spreadPass = this.inputRadiusY > 1.0f || this.inputRadiusY >= this.inputRadiusX ? 1.0f : 0.0f;
            if (scaled) {
                this.space = RenderState.EffectCoordinateSpace.CustomSpace;
                this.inputtx = BaseTransform.getScaleInstance(txScaleX, txScaleY);
                this.resulttx = filtertx.copy().deriveWithScale(1.0 / txScaleX, 1.0 / txScaleY, 1.0);
                this.samplevectors = new float[]{1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f};
            } else {
                this.space = RenderState.EffectCoordinateSpace.RenderSpace;
                this.inputtx = filtertx;
                this.resulttx = BaseTransform.IDENTITY_TRANSFORM;
                this.samplevectors = new float[]{(float)(mxx / txScaleX), (float)(myx / txScaleX), (float)(mxy / txScaleY), (float)(myy / txScaleY), 0.0f, 0.0f};
            }
        }
    }

    public GaussianRenderState(float radius, float dx, float dy, BaseTransform filtertx) {
        this.isShadow = false;
        this.spread = 0.0f;
        if (filtertx == null) {
            filtertx = BaseTransform.IDENTITY_TRANSFORM;
        }
        double mxx = filtertx.getMxx();
        double mxy = filtertx.getMxy();
        double myx = filtertx.getMyx();
        double myy = filtertx.getMyy();
        double tdx = mxx * (double)dx + mxy * (double)dy;
        double tdy = myx * (double)dx + myy * (double)dy;
        double txScale = Math.hypot(tdx, tdy);
        boolean scaled = false;
        float scaledRadius = (float)((double)radius * txScale);
        if (scaledRadius < 0.00390625f) {
            this.inputRadiusX = 0.0f;
            this.inputRadiusY = 0.0f;
            this.spreadPass = 0.0f;
            this.space = RenderState.EffectCoordinateSpace.RenderSpace;
            this.inputtx = filtertx;
            this.resulttx = BaseTransform.IDENTITY_TRANSFORM;
            this.samplevectors = new float[]{1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f};
        } else {
            if (scaledRadius > MAX_RADIUS) {
                scaledRadius = MAX_RADIUS;
                txScale = MAX_RADIUS / radius;
                scaled = true;
            }
            this.inputRadiusX = scaledRadius;
            this.inputRadiusY = 0.0f;
            this.spreadPass = 0.0f;
            if (scaled) {
                BaseTransform a2di;
                double odx = mxy * (double)dx - mxx * (double)dy;
                double ody = myy * (double)dx - myx * (double)dy;
                double txOScale = Math.hypot(odx, ody);
                this.space = RenderState.EffectCoordinateSpace.CustomSpace;
                Affine2D a2d = new Affine2D();
                a2d.scale(txScale, txOScale);
                a2d.rotate(dx, -dy);
                try {
                    a2di = a2d.createInverse();
                }
                catch (NoninvertibleTransformException ex) {
                    a2di = BaseTransform.IDENTITY_TRANSFORM;
                }
                this.inputtx = a2d;
                this.resulttx = filtertx.copy().deriveWithConcatenation(a2di);
                this.samplevectors = new float[]{1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f};
            } else {
                this.space = RenderState.EffectCoordinateSpace.RenderSpace;
                this.inputtx = filtertx;
                this.resulttx = BaseTransform.IDENTITY_TRANSFORM;
                this.samplevectors = new float[]{(float)(tdx / txScale), (float)(tdy / txScale), 0.0f, 0.0f, 0.0f, 0.0f};
            }
        }
    }

    @Override
    public boolean isShadow() {
        return this.isShadow;
    }

    @Override
    public Color4f getShadowColor() {
        return this.shadowColor;
    }

    @Override
    public float[] getPassShadowColorComponents() {
        return this.validatedPass == 0 ? BLACK_COMPONENTS : this.shadowColor.getPremultipliedRGBComponents();
    }

    @Override
    public RenderState.EffectCoordinateSpace getEffectTransformSpace() {
        return this.space;
    }

    @Override
    public BaseTransform getInputTransform(BaseTransform filterTransform) {
        return this.inputtx;
    }

    @Override
    public BaseTransform getResultTransform(BaseTransform filterTransform) {
        return this.resulttx;
    }

    @Override
    public Rectangle getInputClip(int i, Rectangle filterClip) {
        if (filterClip != null) {
            int pady;
            double dx0 = this.samplevectors[0] * this.inputRadiusX;
            double dy0 = this.samplevectors[1] * this.inputRadiusX;
            double dx1 = this.samplevectors[2] * this.inputRadiusY;
            double dy1 = this.samplevectors[3] * this.inputRadiusY;
            int padx = (int)Math.ceil(dx0 + dx1);
            if ((padx | (pady = (int)Math.ceil(dy0 + dy1))) != 0) {
                filterClip = new Rectangle(filterClip);
                filterClip.grow(padx, pady);
            }
        }
        return filterClip;
    }

    @Override
    public ImageData validatePassInput(ImageData src, int pass) {
        this.validatedPass = pass;
        Filterable f = src.getUntransformedImage();
        BaseTransform srcTx = src.getTransform();
        float iRadius = pass == 0 ? this.inputRadiusX : this.inputRadiusY;
        int vecindex = pass * 2;
        if (srcTx.isTranslateOrIdentity()) {
            this.passRadius = iRadius;
            this.samplevectors[4] = this.samplevectors[vecindex];
            this.samplevectors[5] = this.samplevectors[vecindex + 1];
            this.passType = this.validatedPass == 0 ? (GaussianRenderState.nearOne(this.samplevectors[4], f.getPhysicalWidth()) && GaussianRenderState.nearZero(this.samplevectors[5], f.getPhysicalWidth()) ? LinearConvolveRenderState.PassType.HORIZONTAL_CENTERED : LinearConvolveRenderState.PassType.GENERAL_VECTOR) : (GaussianRenderState.nearZero(this.samplevectors[4], f.getPhysicalHeight()) && GaussianRenderState.nearOne(this.samplevectors[5], f.getPhysicalHeight()) ? LinearConvolveRenderState.PassType.VERTICAL_CENTERED : LinearConvolveRenderState.PassType.GENERAL_VECTOR);
        } else {
            this.passType = LinearConvolveRenderState.PassType.GENERAL_VECTOR;
            try {
                srcTx.inverseDeltaTransform(this.samplevectors, vecindex, this.samplevectors, 4, 1);
            }
            catch (NoninvertibleTransformException ex) {
                this.passRadius = 0.0f;
                this.samplevectors[5] = 0.0f;
                this.samplevectors[4] = 0.0f;
                return src;
            }
            double srcScale = Math.hypot(this.samplevectors[4], this.samplevectors[5]);
            float pRad = (float)((double)iRadius * srcScale);
            if (pRad > MAX_RADIUS) {
                pRad = MAX_RADIUS;
                srcScale = MAX_RADIUS / iRadius;
            }
            this.passRadius = pRad;
            this.samplevectors[4] = (float)((double)this.samplevectors[4] / srcScale);
            this.samplevectors[5] = (float)((double)this.samplevectors[5] / srcScale);
        }
        this.samplevectors[4] = this.samplevectors[4] / (float)f.getPhysicalWidth();
        this.samplevectors[5] = this.samplevectors[5] / (float)f.getPhysicalHeight();
        return src;
    }

    @Override
    public Rectangle getPassResultBounds(Rectangle srcdimension, Rectangle outputClip) {
        double r = this.validatedPass == 0 ? (double)this.inputRadiusX : (double)this.inputRadiusY;
        int i = this.validatedPass * 2;
        double dx = (double)this.samplevectors[i + 0] * r;
        double dy = (double)this.samplevectors[i + 1] * r;
        int padx = (int)Math.ceil(Math.abs(dx));
        int pady = (int)Math.ceil(Math.abs(dy));
        Rectangle ret = new Rectangle(srcdimension);
        ret.grow(padx, pady);
        if (outputClip != null) {
            if (this.validatedPass == 0) {
                dx = (double)this.samplevectors[2] * r;
                dy = (double)this.samplevectors[3] * r;
                padx = (int)Math.ceil(Math.abs(dx));
                if ((padx | (pady = (int)Math.ceil(Math.abs(dy)))) != 0) {
                    outputClip = new Rectangle(outputClip);
                    outputClip.grow(padx, pady);
                }
            }
            ret.intersectWith(outputClip);
        }
        return ret;
    }

    @Override
    public LinearConvolveRenderState.PassType getPassType() {
        return this.passType;
    }

    @Override
    public float[] getPassVector() {
        float xoff = this.samplevectors[4];
        float yoff = this.samplevectors[5];
        int ksize = this.getPassKernelSize();
        int center = ksize / 2;
        float[] ret = new float[]{xoff, yoff, (float)(-center) * xoff, (float)(-center) * yoff};
        return ret;
    }

    @Override
    public int getPassWeightsArrayLength() {
        this.validateWeights();
        return this.weights.limit() / 4;
    }

    @Override
    public FloatBuffer getPassWeights() {
        this.validateWeights();
        this.weights.rewind();
        return this.weights;
    }

    @Override
    public int getInputKernelSize(int pass) {
        return 1 + 2 * (int)Math.ceil(pass == 0 ? (double)this.inputRadiusX : (double)this.inputRadiusY);
    }

    @Override
    public int getPassKernelSize() {
        return 1 + 2 * (int)Math.ceil(this.passRadius);
    }

    @Override
    public boolean isNop() {
        if (this.isShadow) {
            return false;
        }
        return this.inputRadiusX < 0.00390625f && this.inputRadiusY < 0.00390625f;
    }

    @Override
    public boolean isPassNop() {
        if (this.isShadow && this.validatedPass == 1) {
            return false;
        }
        return this.passRadius < 0.00390625f;
    }

    private void validateWeights() {
        float s;
        float r = this.passRadius;
        float f = s = (float)this.validatedPass == this.spreadPass ? this.spread : 0.0f;
        if (this.weights == null || this.weightsValidRadius != r || this.weightsValidSpread != s) {
            this.weights = GaussianRenderState.getGaussianWeights(this.weights, (int)Math.ceil(r), r, s);
            this.weightsValidRadius = r;
            this.weightsValidSpread = s;
        }
    }
}

