/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webkit.dom;

import com.sun.webkit.Disposer;
import com.sun.webkit.DisposerRecord;
import com.sun.webkit.Invoker;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.util.concurrent.atomic.AtomicInteger;
import netscape.javascript.JSException;

class JSObject
extends netscape.javascript.JSObject {
    private static final String UNDEFINED = new String("undefined");
    static final int JS_CONTEXT_OBJECT = 0;
    static final int JS_DOM_NODE_OBJECT = 1;
    static final int JS_DOM_WINDOW_OBJECT = 2;
    private final long peer;
    private final int peer_type;
    private static AtomicInteger peerCount = new AtomicInteger();

    JSObject(long peer, int peer_type) {
        this.peer = peer;
        this.peer_type = peer_type;
        if (peer_type == 0) {
            Disposer.addRecord(this, new SelfDisposer(peer, peer_type));
            peerCount.incrementAndGet();
        }
    }

    long getPeer() {
        return this.peer;
    }

    static int test_getPeerCount() {
        return peerCount.get();
    }

    private static native void unprotectImpl(long var0, int var2);

    @Override
    public Object eval(String s) throws JSException {
        Invoker.getInvoker().checkEventThread();
        return JSObject.evalImpl(this.peer, this.peer_type, s);
    }

    private static native Object evalImpl(long var0, int var2, String var3);

    @Override
    public Object getMember(String name) {
        Invoker.getInvoker().checkEventThread();
        return JSObject.getMemberImpl(this.peer, this.peer_type, name);
    }

    private static native Object getMemberImpl(long var0, int var2, String var3);

    @Override
    public void setMember(String name, Object value) throws JSException {
        Invoker.getInvoker().checkEventThread();
        JSObject.setMemberImpl(this.peer, this.peer_type, name, value, AccessController.getContext());
    }

    private static native void setMemberImpl(long var0, int var2, String var3, Object var4, AccessControlContext var5);

    @Override
    public void removeMember(String name) throws JSException {
        Invoker.getInvoker().checkEventThread();
        JSObject.removeMemberImpl(this.peer, this.peer_type, name);
    }

    private static native void removeMemberImpl(long var0, int var2, String var3);

    @Override
    public Object getSlot(int index) throws JSException {
        Invoker.getInvoker().checkEventThread();
        return JSObject.getSlotImpl(this.peer, this.peer_type, index);
    }

    private static native Object getSlotImpl(long var0, int var2, int var3);

    @Override
    public void setSlot(int index, Object value) throws JSException {
        Invoker.getInvoker().checkEventThread();
        JSObject.setSlotImpl(this.peer, this.peer_type, index, value, AccessController.getContext());
    }

    private static native void setSlotImpl(long var0, int var2, int var3, Object var4, AccessControlContext var5);

    @Override
    public Object call(String methodName, Object ... args) throws JSException {
        Invoker.getInvoker().checkEventThread();
        return JSObject.callImpl(this.peer, this.peer_type, methodName, args, AccessController.getContext());
    }

    private static native Object callImpl(long var0, int var2, String var3, Object[] var4, AccessControlContext var5);

    public String toString() {
        Invoker.getInvoker().checkEventThread();
        return JSObject.toStringImpl(this.peer, this.peer_type);
    }

    private static native String toStringImpl(long var0, int var2);

    public boolean equals(Object other) {
        return other == this || other != null && other.getClass() == JSObject.class && this.peer == ((JSObject)other).peer;
    }

    public int hashCode() {
        return (int)(this.peer ^ this.peer >> 17);
    }

    private static JSException fwkMakeException(Object value) {
        String msg = value == null ? null : value.toString();
        JSException ex = new JSException(value == null ? null : value.toString());
        if (value instanceof Throwable) {
            ex.initCause((Throwable)value);
        }
        return ex;
    }

    private static final class SelfDisposer
    implements DisposerRecord {
        long peer;
        final int peer_type;

        private SelfDisposer(long peer, int peer_type) {
            this.peer = peer;
            this.peer_type = peer_type;
        }

        @Override
        public void dispose() {
            if (this.peer != 0L) {
                JSObject.unprotectImpl(this.peer, this.peer_type);
                this.peer = 0L;
                peerCount.decrementAndGet();
            }
        }
    }
}

