/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene;

import com.sun.javafx.cursor.CursorFrame;
import com.sun.javafx.cursor.ImageCursorFrame;
import com.sun.javafx.tk.Toolkit;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javafx.beans.InvalidationListener;
import javafx.beans.NamedArg;
import javafx.beans.Observable;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.property.ReadOnlyDoublePropertyBase;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectPropertyBase;
import javafx.geometry.Dimension2D;
import javafx.scene.Cursor;
import javafx.scene.image.Image;

public class ImageCursor
extends Cursor {
    private ObjectPropertyImpl<Image> image;
    private DoublePropertyImpl hotspotX;
    private DoublePropertyImpl hotspotY;
    private CursorFrame currentCursorFrame;
    private ImageCursorFrame firstCursorFrame;
    private Map<Object, ImageCursorFrame> otherCursorFrames;
    private int activeCounter;
    private InvalidationListener imageListener;

    public final Image getImage() {
        return this.image == null ? null : this.image.get();
    }

    public final ReadOnlyObjectProperty<Image> imageProperty() {
        return this.imagePropertyImpl();
    }

    private ObjectPropertyImpl<Image> imagePropertyImpl() {
        if (this.image == null) {
            this.image = new ObjectPropertyImpl("image");
        }
        return this.image;
    }

    public final double getHotspotX() {
        return this.hotspotX == null ? 0.0 : this.hotspotX.get();
    }

    public final ReadOnlyDoubleProperty hotspotXProperty() {
        return this.hotspotXPropertyImpl();
    }

    private DoublePropertyImpl hotspotXPropertyImpl() {
        if (this.hotspotX == null) {
            this.hotspotX = new DoublePropertyImpl("hotspotX");
        }
        return this.hotspotX;
    }

    public final double getHotspotY() {
        return this.hotspotY == null ? 0.0 : this.hotspotY.get();
    }

    public final ReadOnlyDoubleProperty hotspotYProperty() {
        return this.hotspotYPropertyImpl();
    }

    private DoublePropertyImpl hotspotYPropertyImpl() {
        if (this.hotspotY == null) {
            this.hotspotY = new DoublePropertyImpl("hotspotY");
        }
        return this.hotspotY;
    }

    public ImageCursor() {
    }

    public ImageCursor(@NamedArg(value="image") Image image) {
        this(image, 0.0, 0.0);
    }

    public ImageCursor(@NamedArg(value="image") Image image, @NamedArg(value="hotspotX") double hotspotX, @NamedArg(value="hotspotY") double hotspotY) {
        if (image != null && image.getProgress() < 1.0) {
            DelayedInitialization.applyTo(this, image, hotspotX, hotspotY);
        } else {
            this.initialize(image, hotspotX, hotspotY);
        }
    }

    public static Dimension2D getBestSize(double preferredWidth, double preferredHeight) {
        return Toolkit.getToolkit().getBestCursorSize((int)preferredWidth, (int)preferredHeight);
    }

    public static int getMaximumColors() {
        return Toolkit.getToolkit().getMaximumCursorColors();
    }

    public static ImageCursor chooseBestCursor(Image[] images, double hotspotX, double hotspotY) {
        ImageCursor imageCursor = new ImageCursor();
        if (ImageCursor.needsDelayedInitialization(images)) {
            DelayedInitialization.applyTo(imageCursor, images, hotspotX, hotspotY);
        } else {
            imageCursor.initialize(images, hotspotX, hotspotY);
        }
        return imageCursor;
    }

    @Override
    CursorFrame getCurrentFrame() {
        if (this.currentCursorFrame != null) {
            return this.currentCursorFrame;
        }
        Image cursorImage = this.getImage();
        if (cursorImage == null) {
            this.currentCursorFrame = Cursor.DEFAULT.getCurrentFrame();
            return this.currentCursorFrame;
        }
        Object cursorPlatformImage = cursorImage.impl_getPlatformImage();
        if (cursorPlatformImage == null) {
            this.currentCursorFrame = Cursor.DEFAULT.getCurrentFrame();
            return this.currentCursorFrame;
        }
        if (this.firstCursorFrame == null) {
            this.firstCursorFrame = new ImageCursorFrame(cursorPlatformImage, cursorImage.getWidth(), cursorImage.getHeight(), this.getHotspotX(), this.getHotspotY());
            this.currentCursorFrame = this.firstCursorFrame;
        } else if (this.firstCursorFrame.getPlatformImage() == cursorPlatformImage) {
            this.currentCursorFrame = this.firstCursorFrame;
        } else {
            if (this.otherCursorFrames == null) {
                this.otherCursorFrames = new HashMap<Object, ImageCursorFrame>();
            }
            this.currentCursorFrame = this.otherCursorFrames.get(cursorPlatformImage);
            if (this.currentCursorFrame == null) {
                ImageCursorFrame newCursorFrame = new ImageCursorFrame(cursorPlatformImage, cursorImage.getWidth(), cursorImage.getHeight(), this.getHotspotX(), this.getHotspotY());
                this.otherCursorFrames.put(cursorPlatformImage, newCursorFrame);
                this.currentCursorFrame = newCursorFrame;
            }
        }
        return this.currentCursorFrame;
    }

    private void invalidateCurrentFrame() {
        this.currentCursorFrame = null;
    }

    @Override
    void activate() {
        if (++this.activeCounter == 1) {
            this.bindImage(this.getImage());
            this.invalidateCurrentFrame();
        }
    }

    @Override
    void deactivate() {
        if (--this.activeCounter == 0) {
            this.unbindImage(this.getImage());
        }
    }

    private void initialize(Image[] images, double hotspotX, double hotspotY) {
        Dimension2D dim = ImageCursor.getBestSize(1.0, 1.0);
        if (images.length == 0 || dim.getWidth() == 0.0 || dim.getHeight() == 0.0) {
            return;
        }
        if (images.length == 1) {
            this.initialize(images[0], hotspotX, hotspotY);
            return;
        }
        Image bestImage = ImageCursor.findBestImage(images);
        double scaleX = bestImage.getWidth() / images[0].getWidth();
        double scaleY = bestImage.getHeight() / images[0].getHeight();
        this.initialize(bestImage, hotspotX * scaleX, hotspotY * scaleY);
    }

    private void initialize(Image newImage, double newHotspotX, double newHotspotY) {
        Image oldImage = this.getImage();
        double oldHotspotX = this.getHotspotX();
        double oldHotspotY = this.getHotspotY();
        if (newImage == null || newImage.getWidth() < 1.0 || newImage.getHeight() < 1.0) {
            newHotspotX = 0.0;
            newHotspotY = 0.0;
        } else {
            if (newHotspotX < 0.0) {
                newHotspotX = 0.0;
            }
            if (newHotspotX > newImage.getWidth() - 1.0) {
                newHotspotX = newImage.getWidth() - 1.0;
            }
            if (newHotspotY < 0.0) {
                newHotspotY = 0.0;
            }
            if (newHotspotY > newImage.getHeight() - 1.0) {
                newHotspotY = newImage.getHeight() - 1.0;
            }
        }
        this.imagePropertyImpl().store(newImage);
        this.hotspotXPropertyImpl().store(newHotspotX);
        this.hotspotYPropertyImpl().store(newHotspotY);
        if (oldImage != newImage) {
            if (this.activeCounter > 0) {
                this.unbindImage(oldImage);
                this.bindImage(newImage);
            }
            this.invalidateCurrentFrame();
            this.image.fireValueChangedEvent();
        }
        if (oldHotspotX != newHotspotX) {
            this.hotspotX.fireValueChangedEvent();
        }
        if (oldHotspotY != newHotspotY) {
            this.hotspotY.fireValueChangedEvent();
        }
    }

    private InvalidationListener getImageListener() {
        if (this.imageListener == null) {
            this.imageListener = valueModel -> this.invalidateCurrentFrame();
        }
        return this.imageListener;
    }

    private void bindImage(Image toImage) {
        if (toImage == null) {
            return;
        }
        Toolkit.getImageAccessor().getImageProperty(toImage).addListener(this.getImageListener());
    }

    private void unbindImage(Image fromImage) {
        if (fromImage == null) {
            return;
        }
        Toolkit.getImageAccessor().getImageProperty(fromImage).removeListener(this.getImageListener());
    }

    private static boolean needsDelayedInitialization(Image[] images) {
        for (Image image : images) {
            if (!(image.getProgress() < 1.0)) continue;
            return true;
        }
        return false;
    }

    private static Image findBestImage(Image[] images) {
        double ratio;
        double ratioY;
        double ratioX;
        Dimension2D dim;
        for (Image image : images) {
            Dimension2D dim2 = ImageCursor.getBestSize((int)image.getWidth(), (int)image.getHeight());
            if (dim2.getWidth() != image.getWidth() || dim2.getHeight() != image.getHeight()) continue;
            return image;
        }
        Image bestImage = null;
        double bestRatio = Double.MAX_VALUE;
        for (Image image : images) {
            if (!(image.getWidth() > 0.0) || !(image.getHeight() > 0.0)) continue;
            dim = ImageCursor.getBestSize(image.getWidth(), image.getHeight());
            ratioX = dim.getWidth() / image.getWidth();
            ratioY = dim.getHeight() / image.getHeight();
            if (!(ratioX >= 1.0) || !(ratioY >= 1.0) || !((ratio = Math.max(ratioX, ratioY)) < bestRatio)) continue;
            bestImage = image;
            bestRatio = ratio;
        }
        if (bestImage != null) {
            return bestImage;
        }
        for (Image image : images) {
            if (!(image.getWidth() > 0.0) || !(image.getHeight() > 0.0) || !((dim = ImageCursor.getBestSize(image.getWidth(), image.getHeight())).getWidth() > 0.0) || !(dim.getHeight() > 0.0)) continue;
            ratioX = dim.getWidth() / image.getWidth();
            if (ratioX < 1.0) {
                ratioX = 1.0 / ratioX;
            }
            if ((ratioY = dim.getHeight() / image.getHeight()) < 1.0) {
                ratioY = 1.0 / ratioY;
            }
            if (!((ratio = Math.max(ratioX, ratioY)) < bestRatio)) continue;
            bestImage = image;
            bestRatio = ratio;
        }
        if (bestImage != null) {
            return bestImage;
        }
        return images[0];
    }

    private static final class DelayedInitialization
    implements InvalidationListener {
        private final ImageCursor targetCursor;
        private final Image[] images;
        private final double hotspotX;
        private final double hotspotY;
        private final boolean initAsSingle;
        private int waitForImages;

        private DelayedInitialization(ImageCursor targetCursor, Image[] images, double hotspotX, double hotspotY, boolean initAsSingle) {
            this.targetCursor = targetCursor;
            this.images = images;
            this.hotspotX = hotspotX;
            this.hotspotY = hotspotY;
            this.initAsSingle = initAsSingle;
        }

        public static void applyTo(ImageCursor imageCursor, Image[] images, double hotspotX, double hotspotY) {
            DelayedInitialization delayedInitialization = new DelayedInitialization(imageCursor, Arrays.copyOf(images, images.length), hotspotX, hotspotY, false);
            delayedInitialization.start();
        }

        public static void applyTo(ImageCursor imageCursor, Image image, double hotspotX, double hotspotY) {
            DelayedInitialization delayedInitialization = new DelayedInitialization(imageCursor, new Image[]{image}, hotspotX, hotspotY, true);
            delayedInitialization.start();
        }

        private void start() {
            for (Image image : this.images) {
                if (!(image.getProgress() < 1.0)) continue;
                ++this.waitForImages;
                image.progressProperty().addListener(this);
            }
        }

        private void cleanupAndFinishInitialization() {
            for (Image image : this.images) {
                image.progressProperty().removeListener(this);
            }
            if (this.initAsSingle) {
                this.targetCursor.initialize(this.images[0], this.hotspotX, this.hotspotY);
            } else {
                this.targetCursor.initialize(this.images, this.hotspotX, this.hotspotY);
            }
        }

        @Override
        public void invalidated(Observable valueModel) {
            if (((ReadOnlyDoubleProperty)valueModel).get() == 1.0 && --this.waitForImages == 0) {
                this.cleanupAndFinishInitialization();
            }
        }
    }

    private final class ObjectPropertyImpl<T>
    extends ReadOnlyObjectPropertyBase<T> {
        private final String name;
        private T value;

        public ObjectPropertyImpl(String name) {
            this.name = name;
        }

        public void store(T value) {
            this.value = value;
        }

        @Override
        public void fireValueChangedEvent() {
            super.fireValueChangedEvent();
        }

        @Override
        public T get() {
            return this.value;
        }

        @Override
        public Object getBean() {
            return ImageCursor.this;
        }

        @Override
        public String getName() {
            return this.name;
        }
    }

    private final class DoublePropertyImpl
    extends ReadOnlyDoublePropertyBase {
        private final String name;
        private double value;

        public DoublePropertyImpl(String name) {
            this.name = name;
        }

        public void store(double value) {
            this.value = value;
        }

        @Override
        public void fireValueChangedEvent() {
            super.fireValueChangedEvent();
        }

        @Override
        public double get() {
            return this.value;
        }

        @Override
        public Object getBean() {
            return ImageCursor.this;
        }

        @Override
        public String getName() {
            return this.name;
        }
    }
}

