/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.chart;

import com.sun.javafx.charts.ChartLayoutAnimator;
import com.sun.javafx.charts.Legend;
import com.sun.javafx.css.converters.BooleanConverter;
import com.sun.javafx.css.converters.EnumConverter;
import com.sun.javafx.scene.control.skin.Utils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.animation.Animation;
import javafx.animation.KeyFrame;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.property.StringPropertyBase;
import javafx.collections.ObservableList;
import javafx.css.CssMetaData;
import javafx.css.Styleable;
import javafx.css.StyleableBooleanProperty;
import javafx.css.StyleableObjectProperty;
import javafx.css.StyleableProperty;
import javafx.geometry.Pos;
import javafx.geometry.Side;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;

public abstract class Chart
extends Region {
    private static final int MIN_WIDTH_TO_LEAVE_FOR_CHART_CONTENT = 200;
    private static final int MIN_HEIGHT_TO_LEAVE_FOR_CHART_CONTENT = 150;
    private final Label titleLabel = new Label();
    private final Pane chartContent = new Pane(){

        @Override
        protected void layoutChildren() {
            double top = this.snappedTopInset();
            double left = this.snappedLeftInset();
            double bottom = this.snappedBottomInset();
            double right = this.snappedRightInset();
            double width = this.getWidth();
            double height = this.getHeight();
            double contentWidth = this.snapSize(width - (left + right));
            double contentHeight = this.snapSize(height - (top + bottom));
            Chart.this.layoutChartChildren(this.snapPosition(top), this.snapPosition(left), contentWidth, contentHeight);
        }

        @Override
        public boolean usesMirroring() {
            return Chart.this.useChartContentMirroring;
        }
    };
    boolean useChartContentMirroring = true;
    private final ChartLayoutAnimator animator = new ChartLayoutAnimator(this.chartContent);
    private StringProperty title = new StringPropertyBase(){

        @Override
        protected void invalidated() {
            Chart.this.titleLabel.setText(this.get());
        }

        @Override
        public Object getBean() {
            return Chart.this;
        }

        @Override
        public String getName() {
            return "title";
        }
    };
    private ObjectProperty<Side> titleSide = new StyleableObjectProperty<Side>(Side.TOP){

        @Override
        protected void invalidated() {
            Chart.this.requestLayout();
        }

        @Override
        public CssMetaData<Chart, Side> getCssMetaData() {
            return StyleableProperties.TITLE_SIDE;
        }

        @Override
        public Object getBean() {
            return Chart.this;
        }

        @Override
        public String getName() {
            return "titleSide";
        }
    };
    private final ObjectProperty<Node> legend = new ObjectPropertyBase<Node>(){
        private Node old = null;

        @Override
        protected void invalidated() {
            Node newLegend = (Node)this.get();
            if (this.old != null) {
                Chart.this.getChildren().remove(this.old);
            }
            if (newLegend != null) {
                Chart.this.getChildren().add(newLegend);
                newLegend.setVisible(Chart.this.isLegendVisible());
            }
            this.old = newLegend;
        }

        @Override
        public Object getBean() {
            return Chart.this;
        }

        @Override
        public String getName() {
            return "legend";
        }
    };
    private final BooleanProperty legendVisible = new StyleableBooleanProperty(true){

        @Override
        protected void invalidated() {
            Chart.this.requestLayout();
        }

        @Override
        public CssMetaData<Chart, Boolean> getCssMetaData() {
            return StyleableProperties.LEGEND_VISIBLE;
        }

        @Override
        public Object getBean() {
            return Chart.this;
        }

        @Override
        public String getName() {
            return "legendVisible";
        }
    };
    private ObjectProperty<Side> legendSide = new StyleableObjectProperty<Side>(Side.BOTTOM){

        @Override
        protected void invalidated() {
            Side legendSide = (Side)((Object)this.get());
            Node legend = Chart.this.getLegend();
            if (legend instanceof Legend) {
                ((Legend)legend).setVertical(Side.LEFT.equals((Object)legendSide) || Side.RIGHT.equals((Object)legendSide));
            }
            Chart.this.requestLayout();
        }

        @Override
        public CssMetaData<Chart, Side> getCssMetaData() {
            return StyleableProperties.LEGEND_SIDE;
        }

        @Override
        public Object getBean() {
            return Chart.this;
        }

        @Override
        public String getName() {
            return "legendSide";
        }
    };
    private BooleanProperty animated = new SimpleBooleanProperty(this, "animated", true);

    public final String getTitle() {
        return (String)this.title.get();
    }

    public final void setTitle(String value) {
        this.title.set(value);
    }

    public final StringProperty titleProperty() {
        return this.title;
    }

    public final Side getTitleSide() {
        return (Side)((Object)this.titleSide.get());
    }

    public final void setTitleSide(Side value) {
        this.titleSide.set(value);
    }

    public final ObjectProperty<Side> titleSideProperty() {
        return this.titleSide;
    }

    protected final Node getLegend() {
        return (Node)this.legend.getValue();
    }

    protected final void setLegend(Node value) {
        this.legend.setValue(value);
    }

    protected final ObjectProperty<Node> legendProperty() {
        return this.legend;
    }

    public final boolean isLegendVisible() {
        return this.legendVisible.getValue();
    }

    public final void setLegendVisible(boolean value) {
        this.legendVisible.setValue(value);
    }

    public final BooleanProperty legendVisibleProperty() {
        return this.legendVisible;
    }

    public final Side getLegendSide() {
        return (Side)((Object)this.legendSide.get());
    }

    public final void setLegendSide(Side value) {
        this.legendSide.set(value);
    }

    public final ObjectProperty<Side> legendSideProperty() {
        return this.legendSide;
    }

    public final boolean getAnimated() {
        return this.animated.get();
    }

    public final void setAnimated(boolean value) {
        this.animated.set(value);
    }

    public final BooleanProperty animatedProperty() {
        return this.animated;
    }

    protected ObservableList<Node> getChartChildren() {
        return this.chartContent.getChildren();
    }

    public Chart() {
        this.titleLabel.setAlignment(Pos.CENTER);
        this.titleLabel.focusTraversableProperty().bind(Platform.accessibilityActiveProperty());
        this.getChildren().addAll((Node[])new Node[]{this.titleLabel, this.chartContent});
        this.getStyleClass().add("chart");
        this.titleLabel.getStyleClass().add("chart-title");
        this.chartContent.getStyleClass().add("chart-content");
        this.chartContent.setManaged(false);
    }

    void animate(KeyFrame ... keyFrames) {
        this.animator.animate(keyFrames);
    }

    protected void animate(Animation animation) {
        this.animator.animate(animation);
    }

    protected void requestChartLayout() {
        this.chartContent.requestLayout();
    }

    protected final boolean shouldAnimate() {
        return this.getAnimated() && this.impl_isTreeVisible() && this.getScene() != null;
    }

    protected abstract void layoutChartChildren(double var1, double var3, double var5, double var7);

    @Override
    protected void layoutChildren() {
        double top = this.snappedTopInset();
        double left = this.snappedLeftInset();
        double bottom = this.snappedBottomInset();
        double right = this.snappedRightInset();
        double width = this.getWidth();
        double height = this.getHeight();
        if (this.getTitle() != null) {
            double titleWidth;
            double titleHeight;
            this.titleLabel.setVisible(true);
            if (this.getTitleSide().equals((Object)Side.TOP)) {
                titleHeight = this.snapSize(this.titleLabel.prefHeight(width - left - right));
                this.titleLabel.resizeRelocate(left, top, width - left - right, titleHeight);
                top += titleHeight;
            } else if (this.getTitleSide().equals((Object)Side.BOTTOM)) {
                titleHeight = this.snapSize(this.titleLabel.prefHeight(width - left - right));
                this.titleLabel.resizeRelocate(left, height - bottom - titleHeight, width - left - right, titleHeight);
                bottom += titleHeight;
            } else if (this.getTitleSide().equals((Object)Side.LEFT)) {
                titleWidth = this.snapSize(this.titleLabel.prefWidth(height - top - bottom));
                this.titleLabel.resizeRelocate(left, top, titleWidth, height - top - bottom);
                left += titleWidth;
            } else if (this.getTitleSide().equals((Object)Side.RIGHT)) {
                titleWidth = this.snapSize(this.titleLabel.prefWidth(height - top - bottom));
                this.titleLabel.resizeRelocate(width - right - titleWidth, top, titleWidth, height - top - bottom);
                right += titleWidth;
            }
        } else {
            this.titleLabel.setVisible(false);
        }
        Node legend = this.getLegend();
        if (legend != null) {
            boolean shouldShowLegend = this.isLegendVisible();
            if (shouldShowLegend) {
                if (this.getLegendSide() == Side.TOP) {
                    double legendHeight = this.snapSize(legend.prefHeight(width - left - right));
                    double legendWidth = Utils.boundedSize(this.snapSize(legend.prefWidth(legendHeight)), 0.0, width - left - right);
                    legend.resizeRelocate(left + (width - left - right - legendWidth) / 2.0, top, legendWidth, legendHeight);
                    if (height - bottom - top - legendHeight < 150.0) {
                        shouldShowLegend = false;
                    } else {
                        top += legendHeight;
                    }
                } else if (this.getLegendSide() == Side.BOTTOM) {
                    double legendHeight = this.snapSize(legend.prefHeight(width - left - right));
                    double legendWidth = Utils.boundedSize(this.snapSize(legend.prefWidth(legendHeight)), 0.0, width - left - right);
                    legend.resizeRelocate(left + (width - left - right - legendWidth) / 2.0, height - bottom - legendHeight, legendWidth, legendHeight);
                    if (height - bottom - top - legendHeight < 150.0) {
                        shouldShowLegend = false;
                    } else {
                        bottom += legendHeight;
                    }
                } else if (this.getLegendSide() == Side.LEFT) {
                    double legendWidth = this.snapSize(legend.prefWidth(height - top - bottom));
                    double legendHeight = Utils.boundedSize(this.snapSize(legend.prefHeight(legendWidth)), 0.0, height - top - bottom);
                    legend.resizeRelocate(left, top + (height - top - bottom - legendHeight) / 2.0, legendWidth, legendHeight);
                    if (width - left - right - legendWidth < 200.0) {
                        shouldShowLegend = false;
                    } else {
                        left += legendWidth;
                    }
                } else if (this.getLegendSide() == Side.RIGHT) {
                    double legendWidth = this.snapSize(legend.prefWidth(height - top - bottom));
                    double legendHeight = Utils.boundedSize(this.snapSize(legend.prefHeight(legendWidth)), 0.0, height - top - bottom);
                    legend.resizeRelocate(width - right - legendWidth, top + (height - top - bottom - legendHeight) / 2.0, legendWidth, legendHeight);
                    if (width - left - right - legendWidth < 200.0) {
                        shouldShowLegend = false;
                    } else {
                        right += legendWidth;
                    }
                }
            }
            legend.setVisible(shouldShowLegend);
        }
        this.chartContent.resizeRelocate(left, top, width - left - right, height - top - bottom);
    }

    @Override
    protected double computeMinHeight(double width) {
        return 150.0;
    }

    @Override
    protected double computeMinWidth(double height) {
        return 200.0;
    }

    @Override
    protected double computePrefWidth(double height) {
        return 500.0;
    }

    @Override
    protected double computePrefHeight(double width) {
        return 400.0;
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.STYLEABLES;
    }

    @Override
    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return Chart.getClassCssMetaData();
    }

    private static class StyleableProperties {
        private static final CssMetaData<Chart, Side> TITLE_SIDE = new CssMetaData<Chart, Side>("-fx-title-side", new EnumConverter<Side>(Side.class), Side.TOP){

            @Override
            public boolean isSettable(Chart node) {
                return node.titleSide == null || !node.titleSide.isBound();
            }

            @Override
            public StyleableProperty<Side> getStyleableProperty(Chart node) {
                return (StyleableProperty)((Object)node.titleSideProperty());
            }
        };
        private static final CssMetaData<Chart, Side> LEGEND_SIDE = new CssMetaData<Chart, Side>("-fx-legend-side", new EnumConverter<Side>(Side.class), Side.BOTTOM){

            @Override
            public boolean isSettable(Chart node) {
                return node.legendSide == null || !node.legendSide.isBound();
            }

            @Override
            public StyleableProperty<Side> getStyleableProperty(Chart node) {
                return (StyleableProperty)((Object)node.legendSideProperty());
            }
        };
        private static final CssMetaData<Chart, Boolean> LEGEND_VISIBLE = new CssMetaData<Chart, Boolean>("-fx-legend-visible", BooleanConverter.getInstance(), Boolean.TRUE){

            @Override
            public boolean isSettable(Chart node) {
                return node.legendVisible == null || !node.legendVisible.isBound();
            }

            @Override
            public StyleableProperty<Boolean> getStyleableProperty(Chart node) {
                return (StyleableProperty)((Object)node.legendVisibleProperty());
            }
        };
        private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;

        private StyleableProperties() {
        }

        static {
            ArrayList styleables = new ArrayList(Region.getClassCssMetaData());
            styleables.add(TITLE_SIDE);
            styleables.add(LEGEND_VISIBLE);
            styleables.add(LEGEND_SIDE);
            STYLEABLES = Collections.unmodifiableList(styleables);
        }
    }
}

