/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.io.wrappers;

import java.io.DataOutput;
import java.io.IOException;
import java.util.Map;
import org.openimaj.io.WriteableBinary;

public abstract class WriteableMapBinary<K, V>
implements WriteableBinary {
    public Map<K, V> value;

    public WriteableMapBinary(Map<K, V> map) {
        this.value = map;
    }

    @Override
    public void writeBinary(DataOutput out) throws IOException {
        out.writeInt(this.value.size());
        for (Map.Entry<K, V> entry : this.value.entrySet()) {
            this.writeKey(entry.getKey(), out);
            this.writeValue(entry.getValue(), out);
        }
    }

    protected abstract void writeKey(K var1, DataOutput var2) throws IOException;

    protected abstract void writeValue(V var1, DataOutput var2) throws IOException;

    @Override
    public byte[] binaryHeader() {
        return this.value.getClass().getName().getBytes();
    }
}

