/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.util.parallel.partition;

import java.util.ArrayList;
import java.util.Iterator;
import org.openimaj.util.parallel.partition.Partitioner;

public class FixedSizeChunkPartitioner<T>
implements Partitioner<T> {
    private Iterator<T> objects;
    private int chunkSize = 20;

    public FixedSizeChunkPartitioner(Iterable<T> objects) {
        this.objects = objects.iterator();
    }

    public FixedSizeChunkPartitioner(Iterable<T> objects, int chunkSize) {
        this.objects = objects.iterator();
        this.chunkSize = chunkSize;
    }

    @Override
    public Iterator<Iterator<T>> getPartitions() {
        return new Iterator<Iterator<T>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean hasNext() {
                Iterator iterator = FixedSizeChunkPartitioner.this.objects;
                synchronized (iterator) {
                    return FixedSizeChunkPartitioner.this.objects.hasNext();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Iterator<T> next() {
                Iterator iterator = FixedSizeChunkPartitioner.this.objects;
                synchronized (iterator) {
                    if (!FixedSizeChunkPartitioner.this.objects.hasNext()) {
                        return null;
                    }
                    ArrayList list = new ArrayList(FixedSizeChunkPartitioner.this.chunkSize);
                    for (int i = 0; FixedSizeChunkPartitioner.this.objects.hasNext() && i < FixedSizeChunkPartitioner.this.chunkSize; ++i) {
                        list.add(FixedSizeChunkPartitioner.this.objects.next());
                    }
                    return list.iterator();
                }
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Not supported");
            }
        };
    }
}

