/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.math.matrix;

import ch.akuhn.matrix.Matrix;
import ch.akuhn.matrix.Vector;

public class DiagonalMatrix
extends Matrix {
    private double[] vals;

    public DiagonalMatrix(int rowcol) {
        this.vals = new double[rowcol];
    }

    public DiagonalMatrix(int rowcol, double val) {
        this.vals = new double[rowcol];
        for (int i = 0; i < this.vals.length; ++i) {
            this.vals[i] = val;
        }
    }

    public DiagonalMatrix(double[][] arr) {
        this(Math.min(arr.length, arr[0].length));
        for (int i = 0; i < this.vals.length; ++i) {
            this.vals[i] = arr[i][i];
        }
    }

    public DiagonalMatrix(Matrix mat) {
        this(Math.min(mat.rowCount(), mat.columnCount()));
        for (int i = 0; i < this.vals.length; ++i) {
            this.vals[i] = mat.get(i, i);
        }
    }

    public Vector mult(Vector x) {
        double[] y = new double[this.columnCount()];
        for (int i = 0; i < y.length; ++i) {
            y[i] = this.vals[i] * x.get(i);
        }
        return Vector.wrap((double[])y);
    }

    public Vector transposeMultiply(Vector x) {
        return this.mult(x);
    }

    public Vector transposeNonTransposeMultiply(Vector x) {
        double[] y = new double[this.columnCount()];
        for (int i = 0; i < y.length; ++i) {
            y[i] = this.vals[i] * this.vals[i] * x.get(i);
        }
        return Vector.wrap((double[])y);
    }

    public int columnCount() {
        return this.vals.length;
    }

    public double get(int row, int column) {
        if (row != column) {
            return 0.0;
        }
        return this.vals[row];
    }

    public double put(int row, int column, double value) {
        if (row == column) {
            this.vals[row] = value;
            return this.vals[row];
        }
        return 0.0;
    }

    public int rowCount() {
        return this.vals.length;
    }

    public int used() {
        return this.vals.length;
    }

    public static DiagonalMatrix zeros(int rowcol) {
        return DiagonalMatrix.fill(rowcol, 0.0);
    }

    public static DiagonalMatrix ones(int rowcol) {
        return DiagonalMatrix.fill(rowcol, 1.0);
    }

    public static DiagonalMatrix fill(int rowcol, double d) {
        DiagonalMatrix ret = new DiagonalMatrix(rowcol);
        for (int i = 0; i < rowcol; ++i) {
            ret.vals[i] = d;
        }
        return ret;
    }

    public double[] getVals() {
        return this.vals;
    }

    public Matrix newInstance(int rows, int cols) {
        return new DiagonalMatrix(rows);
    }
}

