/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.math.matrix.similarity;

import Jama.Matrix;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Scanner;
import org.jgrapht.UndirectedGraph;
import org.jgrapht.graph.DefaultEdge;
import org.jgrapht.graph.SimpleGraph;
import org.openimaj.io.ReadWriteable;
import org.openimaj.math.matrix.ReadWriteableMatrix;
import org.openimaj.math.matrix.similarity.processor.SimilarityMatrixProcessor;

public class SimilarityMatrix
extends ReadWriteableMatrix
implements ReadWriteable {
    private static final long serialVersionUID = 1L;
    protected String[] index;

    protected SimilarityMatrix() {
    }

    public SimilarityMatrix(int size) {
        super(size, size);
        this.index = new String[size];
    }

    public SimilarityMatrix(String[] index) {
        super(index.length, index.length);
        this.index = index;
    }

    public SimilarityMatrix(String[] index, Matrix data) {
        super(data);
        if (data.getColumnDimension() != data.getRowDimension()) {
            throw new IllegalArgumentException("matrix must be square");
        }
        if (index.length != data.getRowDimension()) {
            throw new IllegalArgumentException("index must have same length as matrix sides");
        }
        this.index = index;
    }

    public SimilarityMatrix(String[] index, double[][] data) {
        super(data);
        if (index.length != this.getRowDimension()) {
            throw new IllegalArgumentException("index must have same length as matrix sides");
        }
        this.index = index;
    }

    public int indexOf(String value) {
        return Arrays.binarySearch(this.index, value);
    }

    public void setIndexValue(int i, String value) {
        this.index[i] = value;
    }

    public String getIndexValue(int i) {
        return this.index[i];
    }

    public String[] getIndex() {
        return this.index;
    }

    @Override
    public void readASCII(Scanner in) throws IOException {
        super.readASCII(in);
        this.index = new String[this.getRowDimension()];
        for (int i = 0; i < this.index.length; ++i) {
            this.index[i] = in.nextLine();
        }
    }

    @Override
    public String asciiHeader() {
        return ((Object)((Object)this)).getClass().getName() + " ";
    }

    @Override
    public void readBinary(DataInput in) throws IOException {
        super.readBinary(in);
        this.index = new String[this.getRowDimension()];
        for (int i = 0; i < this.index.length; ++i) {
            this.index[i] = in.readUTF();
        }
    }

    @Override
    public byte[] binaryHeader() {
        return "SimMat".getBytes();
    }

    @Override
    public void writeASCII(PrintWriter out) throws IOException {
        super.writeASCII(out);
        for (String s : this.index) {
            out.println(s);
        }
    }

    @Override
    public void writeBinary(DataOutput out) throws IOException {
        super.writeBinary(out);
        for (String s : this.index) {
            out.writeUTF(s);
        }
    }

    public UndirectedGraph<String, DefaultEdge> toUndirectedUnweightedGraph(double threshold) {
        SimpleGraph graph = new SimpleGraph(DefaultEdge.class);
        int rows = this.getRowDimension();
        int cols = this.getColumnDimension();
        double[][] data = this.getArray();
        for (String s : this.index) {
            graph.addVertex((Object)s);
        }
        for (int r = 0; r < rows; ++r) {
            for (int c = 0; c < cols; ++c) {
                if (r == c || !(data[r][c] > threshold)) continue;
                graph.addEdge((Object)this.index[r], (Object)this.index[c]);
            }
        }
        return graph;
    }

    public SimilarityMatrix copy() {
        double[][] C = this.getArrayCopy();
        String[] i = Arrays.copyOf(this.index, this.index.length);
        return new SimilarityMatrix(i, C);
    }

    public SimilarityMatrix clone() {
        return this.copy();
    }

    public SimilarityMatrix process(SimilarityMatrixProcessor proc) {
        SimilarityMatrix mat = this.clone();
        proc.process(mat);
        return mat;
    }

    public SimilarityMatrix processInplace(SimilarityMatrixProcessor proc) {
        proc.process(this);
        return this;
    }

    public String toString() {
        int r;
        StringBuilder sb = new StringBuilder();
        int maxIndexLength = 0;
        for (String s : this.index) {
            if (s.length() <= maxIndexLength) continue;
            maxIndexLength = s.length();
        }
        int maxIndexCountLength = (this.index.length + "").length();
        String indexFormatString = "%" + (maxIndexCountLength + 2) + "s %" + maxIndexLength + "s ";
        int rows = this.getRowDimension();
        int cols = this.getColumnDimension();
        double[][] data = this.getArray();
        sb.append(String.format("%" + (maxIndexLength + maxIndexCountLength + 3) + "s", ""));
        for (r = 0; r < rows; ++r) {
            sb.append(String.format("%9s", String.format("(%d)", r)));
        }
        sb.append("\n");
        for (r = 0; r < rows; ++r) {
            sb.append(String.format(indexFormatString, String.format("(%d)", r), this.index[r]));
            for (int c = 0; c < cols; ++c) {
                sb.append(String.format("%8.3f ", data[r][c]));
            }
            sb.append("\n");
        }
        return sb.toString();
    }
}

