/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.math.util.distance;

public class HammingUtils {
    private static int[] BYTE_BIT_COUNTS = new int[256];
    private static final int LONG_BYTES = 8;
    private static final int INT_BYTES = 4;
    private static final int SHORT_BYTES = 2;
    private static final int CHAR_BYTES = 2;

    public static int packedHamming(double i1, double i2) {
        long i1l = Double.doubleToRawLongBits(i1);
        long i2l = Double.doubleToRawLongBits(i2);
        return HammingUtils.packedHamming(i1l, i2l);
    }

    public static int packedHamming(float i1, float i2) {
        int i1l = Float.floatToIntBits(i1);
        int i2l = Float.floatToIntBits(i2);
        return HammingUtils.packedHamming(i1l, i2l);
    }

    public static int packedHamming(long i1, long i2) {
        int h = 0;
        for (int i = 0; i < 8; ++i) {
            byte b1 = (byte)(i1 & 0xFFL);
            i1 >>= 8;
            byte b2 = (byte)(i2 & 0xFFL);
            i2 >>= 8;
            h += HammingUtils.packedHamming(b1, b2);
        }
        return h;
    }

    public static int packedHamming(int i1, int i2) {
        int h = 0;
        for (int i = 0; i < 4; ++i) {
            byte b1 = (byte)(i1 & 0xFF);
            i1 >>= 8;
            byte b2 = (byte)(i2 & 0xFF);
            i2 >>= 8;
            h += HammingUtils.packedHamming(b1, b2);
        }
        return h;
    }

    public static int packedHamming(byte i1, byte i2) {
        return BYTE_BIT_COUNTS[(i1 ^ i2) & 0xFF];
    }

    public static int packedHamming(char i1, char i2) {
        int h = 0;
        for (int i = 0; i < 2; ++i) {
            byte b1 = (byte)(i1 & 0xFF);
            i1 = (char)(i1 >> 8);
            byte b2 = (byte)(i2 & 0xFF);
            i2 = (char)(i2 >> 8);
            h += HammingUtils.packedHamming(b1, b2);
        }
        return h;
    }

    public static int packedHamming(short i1, short i2) {
        int h = 0;
        for (int i = 0; i < 2; ++i) {
            byte b1 = (byte)(i1 & 0xFF);
            i1 = (short)(i1 >> 8);
            byte b2 = (byte)(i2 & 0xFF);
            i2 = (short)(i2 >> 8);
            h += HammingUtils.packedHamming(b1, b2);
        }
        return h;
    }

    public static double unpackDouble(String bits) {
        return Double.longBitsToDouble(Long.parseLong(bits, 2));
    }

    public static float unpackFloat(String bits) {
        return Float.intBitsToFloat(Integer.parseInt(bits, 2));
    }

    public static int unpackInt(String bits) {
        return Integer.parseInt(bits, 2);
    }

    public static long unpackLong(String bits) {
        return Long.parseLong(bits, 2);
    }

    public static short unpackShort(String bits) {
        return Short.parseShort(bits, 2);
    }

    public static byte unpackByte(String bits) {
        return Byte.parseByte(bits, 2);
    }

    static {
        for (int i = 0; i < 256; ++i) {
            HammingUtils.BYTE_BIT_COUNTS[i] = (i & 1) + BYTE_BIT_COUNTS[i / 2];
        }
    }
}

