/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.containers.mp4.boxes;

import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.LinkedList;
import org.jcodec.common.JCodecUtil;
import org.jcodec.common.NIOUtils;
import org.jcodec.containers.mp4.boxes.Box;
import org.jcodec.containers.mp4.boxes.Header;

public class SegmentTypeBox
extends Box {
    private String majorBrand;
    private int minorVersion;
    private Collection<String> compBrands = new LinkedList<String>();

    public static String fourcc() {
        return "styp";
    }

    public SegmentTypeBox(String majorBrand, int minorVersion, Collection<String> compBrands) {
        super(new Header(SegmentTypeBox.fourcc()));
        this.majorBrand = majorBrand;
        this.minorVersion = minorVersion;
        this.compBrands = compBrands;
    }

    public SegmentTypeBox() {
        super(new Header(SegmentTypeBox.fourcc()));
    }

    @Override
    public void parse(ByteBuffer input) {
        String brand;
        this.majorBrand = NIOUtils.readString(input, 4);
        this.minorVersion = input.getInt();
        while ((brand = NIOUtils.readString(input, 4)) != null) {
            this.compBrands.add(brand);
        }
    }

    public String getMajorBrand() {
        return this.majorBrand;
    }

    public Collection<String> getCompBrands() {
        return this.compBrands;
    }

    @Override
    public void doWrite(ByteBuffer out) {
        out.put(JCodecUtil.asciiString(this.majorBrand));
        out.putInt(this.minorVersion);
        for (String string : this.compBrands) {
            out.put(JCodecUtil.asciiString(string));
        }
    }
}

