/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.containers.mps;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jcodec.codecs.mpeg12.MPEGES;
import org.jcodec.codecs.mpeg12.SegmentReader;
import org.jcodec.common.DemuxerTrackMeta;
import org.jcodec.common.NIOUtils;
import org.jcodec.common.SeekableByteChannel;
import org.jcodec.common.model.Packet;
import org.jcodec.common.model.TapeTimecode;
import org.jcodec.containers.mps.MPEGDemuxer;
import org.jcodec.containers.mps.MPSUtils;

public class MPSDemuxer
extends SegmentReader
implements MPEGDemuxer {
    private static final int BUFFER_SIZE = 0x100000;
    private Map<Integer, BaseTrack> streams = new HashMap<Integer, BaseTrack>();
    private SeekableByteChannel channel;
    private List<ByteBuffer> bufPool = new ArrayList<ByteBuffer>();

    public MPSDemuxer(SeekableByteChannel channel) throws IOException {
        super(channel);
        this.channel = channel;
        this.findStreams();
    }

    protected void findStreams() throws IOException {
        PESPacket nextPacket;
        for (int i = 0; (i == 0 || i < 5 * this.streams.size() && this.streams.size() < 2) && (nextPacket = this.nextPacket(this.getBuffer())) != null; ++i) {
            this.addToStream(nextPacket);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteBuffer getBuffer() {
        List<ByteBuffer> list = this.bufPool;
        synchronized (list) {
            if (this.bufPool.size() > 0) {
                return this.bufPool.remove(0);
            }
        }
        return ByteBuffer.allocate(0x100000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putBack(ByteBuffer buffer) {
        buffer.clear();
        List<ByteBuffer> list = this.bufPool;
        synchronized (list) {
            this.bufPool.add(buffer);
        }
    }

    @Override
    public void seekByte(long offset) throws IOException {
        this.channel.position(offset);
        this.reset();
    }

    public void reset() {
        for (BaseTrack track : this.streams.values()) {
            track.pending.clear();
        }
    }

    private void addToStream(PESPacket pkt) throws IOException {
        BaseTrack pes = this.streams.get(pkt.streamId);
        if (pes == null) {
            pes = this.isMPEG(pkt.data) ? new MPEGTrack(pkt.streamId, pkt) : new PlainTrack(pkt.streamId, pkt);
            this.streams.put(pkt.streamId, pes);
        } else {
            pes.pending(pkt);
        }
    }

    public PESPacket nextPacket(ByteBuffer out) throws IOException {
        ByteBuffer dup = out.duplicate();
        while (!MPSUtils.psMarker(this.curMarker)) {
            if (this.skipToMarker()) continue;
            return null;
        }
        ByteBuffer fork = dup.duplicate();
        this.readToNextMarker(dup);
        PESPacket pkt = MPSUtils.readPESHeader(fork, this.curPos());
        if (pkt.length == 0) {
            while (!MPSUtils.psMarker(this.curMarker) && this.readToNextMarker(dup)) {
            }
        } else {
            this.read(dup, pkt.length - dup.position() + 6);
        }
        fork.limit(dup.position());
        pkt.data = fork;
        return pkt;
    }

    public List<MPEGDemuxer.MPEGDemuxerTrack> getTracks() {
        return new ArrayList<MPEGDemuxer.MPEGDemuxerTrack>(this.streams.values());
    }

    public List<MPEGDemuxer.MPEGDemuxerTrack> getVideoTracks() {
        ArrayList<MPEGDemuxer.MPEGDemuxerTrack> result = new ArrayList<MPEGDemuxer.MPEGDemuxerTrack>();
        for (BaseTrack p : this.streams.values()) {
            if (!MPSUtils.videoStream(p.streamId)) continue;
            result.add(p);
        }
        return result;
    }

    public List<MPEGDemuxer.MPEGDemuxerTrack> getAudioTracks() {
        ArrayList<MPEGDemuxer.MPEGDemuxerTrack> result = new ArrayList<MPEGDemuxer.MPEGDemuxerTrack>();
        for (BaseTrack p : this.streams.values()) {
            if (!MPSUtils.audioStream(p.streamId)) continue;
            result.add(p);
        }
        return result;
    }

    private boolean isMPEG(ByteBuffer _data) {
        ByteBuffer b = _data.duplicate();
        int marker = -1;
        int score = 0;
        boolean hasHeader = false;
        boolean slicesStarted = false;
        while (b.hasRemaining()) {
            int code = b.get() & 0xFF;
            if ((marker = marker << 8 | code) < 256 || marker > 440) continue;
            if (marker >= 432 && marker <= 440) {
                if (hasHeader && marker != 437 && marker != 434 || slicesStarted) break;
                score += 5;
                continue;
            }
            if (marker == 256) {
                if (slicesStarted) break;
                hasHeader = true;
                continue;
            }
            if (marker <= 256 || marker >= 432) continue;
            if (!hasHeader) break;
            if (!slicesStarted) {
                score += 50;
                slicesStarted = true;
            }
            ++score;
        }
        return score > 50;
    }

    public static int probe(ByteBuffer b) {
        int marker = -1;
        int score = 0;
        boolean inVideoPes = false;
        boolean hasHeader = false;
        boolean slicesStarted = false;
        while (b.hasRemaining()) {
            int code = b.get() & 0xFF;
            if ((marker = marker << 8 | code) < 256 || marker > 511) continue;
            if (MPSUtils.videoMarker(marker)) {
                if (inVideoPes) break;
                inVideoPes = true;
                continue;
            }
            if (marker >= 432 && marker <= 440 && inVideoPes) {
                if (hasHeader && marker != 437 && marker != 434 || slicesStarted) break;
                score += 5;
                continue;
            }
            if (marker == 256 && inVideoPes) {
                if (slicesStarted) break;
                hasHeader = true;
                continue;
            }
            if (marker <= 256 || marker >= 432) continue;
            if (!hasHeader) break;
            if (!slicesStarted) {
                score += 50;
                slicesStarted = true;
            }
            ++score;
        }
        return score;
    }

    public static class MPEGPacket
    extends Packet {
        private long offset;
        private ByteBuffer seq;
        private int gop;
        private int timecode;

        public MPEGPacket(ByteBuffer data, long pts, long timescale, long duration, long frameNo, boolean keyFrame, TapeTimecode tapeTimecode) {
            super(data, pts, timescale, duration, frameNo, keyFrame, tapeTimecode);
        }

        public long getOffset() {
            return this.offset;
        }

        public ByteBuffer getSeq() {
            return this.seq;
        }

        public int getGOP() {
            return this.gop;
        }

        public int getTimecode() {
            return this.timecode;
        }
    }

    public class PlainTrack
    extends BaseTrack {
        private int frameNo;

        public PlainTrack(int streamId, PESPacket pkt) throws IOException {
            super(streamId, pkt);
        }

        public boolean isOpen() {
            return true;
        }

        public void close() throws IOException {
        }

        @Override
        public Packet nextFrame(ByteBuffer buf) throws IOException {
            Packet packet;
            PESPacket pkt;
            if (this.pending.size() > 0) {
                pkt = (PESPacket)this.pending.remove(0);
            } else {
                while ((pkt = MPSDemuxer.this.nextPacket(MPSDemuxer.this.getBuffer())) != null && pkt.streamId != this.streamId) {
                    MPSDemuxer.this.addToStream(pkt);
                }
            }
            if (pkt == null) {
                packet = null;
            } else {
                int n = this.frameNo++;
                packet = new Packet(pkt.data, pkt.pts, 90000L, 0L, n, true, null);
            }
            return packet;
        }

        @Override
        public DemuxerTrackMeta getMeta() {
            return new DemuxerTrackMeta(MPSUtils.videoStream(this.streamId) ? DemuxerTrackMeta.Type.VIDEO : (MPSUtils.audioStream(this.streamId) ? DemuxerTrackMeta.Type.AUDIO : DemuxerTrackMeta.Type.OTHER), null, 0, 0.0, null);
        }
    }

    public class MPEGTrack
    extends BaseTrack
    implements ReadableByteChannel {
        private MPEGES es;

        public MPEGTrack(int streamId, PESPacket pkt) throws IOException {
            super(streamId, pkt);
            this.es = new MPEGES(this);
        }

        @Override
        public boolean isOpen() {
            return true;
        }

        public MPEGES getES() {
            return this.es;
        }

        @Override
        public void close() throws IOException {
        }

        @Override
        public int read(ByteBuffer arg0) throws IOException {
            PESPacket pes;
            PESPacket pESPacket = pes = this.pending.size() > 0 ? (PESPacket)this.pending.remove(0) : this.getPacket();
            if (pes == null || !pes.data.hasRemaining()) {
                return -1;
            }
            int toRead = Math.min(arg0.remaining(), pes.data.remaining());
            arg0.put(NIOUtils.read(pes.data, toRead));
            if (pes.data.hasRemaining()) {
                this.pending.add(0, pes);
            } else {
                MPSDemuxer.this.putBack(pes.data);
            }
            return toRead;
        }

        private PESPacket getPacket() throws IOException {
            PESPacket pkt;
            if (this.pending.size() > 0) {
                return (PESPacket)this.pending.remove(0);
            }
            while ((pkt = MPSDemuxer.this.nextPacket(MPSDemuxer.this.getBuffer())) != null) {
                if (pkt.streamId == this.streamId) {
                    if (pkt.pts != -1L) {
                        this.es.curPts = pkt.pts;
                    }
                    return pkt;
                }
                MPSDemuxer.this.addToStream(pkt);
            }
            return null;
        }

        @Override
        public Packet nextFrame(ByteBuffer buf) throws IOException {
            return this.es.getFrame(buf);
        }

        @Override
        public DemuxerTrackMeta getMeta() {
            return new DemuxerTrackMeta(MPSUtils.videoStream(this.streamId) ? DemuxerTrackMeta.Type.VIDEO : (MPSUtils.audioStream(this.streamId) ? DemuxerTrackMeta.Type.AUDIO : DemuxerTrackMeta.Type.OTHER), null, 0, 0.0, null);
        }
    }

    public abstract class BaseTrack
    implements MPEGDemuxer.MPEGDemuxerTrack {
        protected int streamId;
        protected List<PESPacket> pending = new ArrayList<PESPacket>();

        public BaseTrack(int streamId, PESPacket pkt) throws IOException {
            this.streamId = streamId;
            this.pending.add(pkt);
        }

        public int getSid() {
            return this.streamId;
        }

        public void pending(PESPacket pkt) {
            if (this.pending != null) {
                this.pending.add(pkt);
            } else {
                MPSDemuxer.this.putBack(pkt.data);
            }
        }

        public List<PESPacket> getPending() {
            return this.pending;
        }

        @Override
        public void ignore() {
            if (this.pending == null) {
                return;
            }
            for (PESPacket pesPacket : this.pending) {
                MPSDemuxer.this.putBack(pesPacket.data);
            }
            this.pending = null;
        }
    }

    public static class PESPacket {
        public ByteBuffer data;
        public long pts;
        public int streamId;
        public int length;
        public long pos;
        public long dts;

        public PESPacket(ByteBuffer data, long pts, int streamId, int length, long pos, long dts) {
            this.data = data;
            this.pts = pts;
            this.streamId = streamId;
            this.length = length;
            this.pos = pos;
            this.dts = dts;
        }
    }
}

