/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.testing;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jcodec.codecs.h264.H264Decoder;
import org.jcodec.codecs.h264.H264Utils;
import org.jcodec.codecs.h264.mp4.AvcCBox;
import org.jcodec.common.FileChannelWrapper;
import org.jcodec.common.IOUtils;
import org.jcodec.common.JCodecUtil;
import org.jcodec.common.NIOUtils;
import org.jcodec.common.SeekableByteChannel;
import org.jcodec.common.model.ColorSpace;
import org.jcodec.common.model.Packet;
import org.jcodec.common.model.Picture;
import org.jcodec.containers.mp4.boxes.Box;
import org.jcodec.containers.mp4.boxes.LeafBox;
import org.jcodec.containers.mp4.boxes.NodeBox;
import org.jcodec.containers.mp4.boxes.VideoSampleEntry;
import org.jcodec.containers.mp4.demuxer.AbstractMP4DemuxerTrack;
import org.jcodec.containers.mp4.demuxer.MP4Demuxer;

public class TestTool {
    private String jm;
    private File coded;
    private File decoded;
    private File jmconf;
    private File errs;

    public TestTool(String jm, String errs) throws IOException {
        this.jm = jm;
        this.errs = new File(errs);
        this.coded = File.createTempFile("seq", ".264");
        this.decoded = File.createTempFile("seq_dec", ".yuv");
        this.jmconf = File.createTempFile("ldecod", ".conf");
        this.prepareJMConf();
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 3) {
            System.out.println("JCodec h.264 test tool");
            System.out.println("Syntax: <path to ldecod> <movie file> <foder for errors>");
            return;
        }
        new TestTool(args[0], args[2]).doIt(args[1]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doIt(String in) throws Exception {
        Channel raw = null;
        Channel source = null;
        try {
            Packet inFrame;
            source = new FileChannelWrapper(new FileInputStream(in).getChannel());
            MP4Demuxer demux = new MP4Demuxer((SeekableByteChannel)source);
            H264Decoder decoder = new H264Decoder();
            AbstractMP4DemuxerTrack inTrack = demux.getVideoTrack();
            VideoSampleEntry ine = (VideoSampleEntry)inTrack.getSampleEntries()[0];
            AvcCBox avcC = Box.as(AvcCBox.class, Box.findFirst((NodeBox)ine, LeafBox.class, "avcC"));
            ByteBuffer _rawData = ByteBuffer.allocate(12533760);
            decoder.addSps(avcC.getSpsList());
            decoder.addPps(avcC.getPpsList());
            int sf = 2600;
            AbstractMP4DemuxerTrack dt = inTrack;
            dt.gotoFrame(sf);
            while ((inFrame = inTrack.nextFrame()) != null && !inFrame.isKeyFrame()) {
            }
            dt.gotoFrame(inFrame.getFrameNo());
            ArrayList<Picture> decodedPics = new ArrayList<Picture>();
            int totalFrames = (int)inTrack.getFrameCount();
            int seqNo = 0;
            int i = sf;
            while ((inFrame = inTrack.nextFrame()) != null) {
                ByteBuffer data = inFrame.getData();
                List<ByteBuffer> nalUnits = H264Utils.splitMOVPacket(data, avcC);
                _rawData.clear();
                H264Utils.joinNALUnits(nalUnits, _rawData);
                _rawData.flip();
                if (H264Utils.idrSlice(_rawData)) {
                    if (raw != null) {
                        raw.close();
                        this.runJMCompareResults(decodedPics, seqNo);
                        decodedPics = new ArrayList();
                        seqNo = i;
                    }
                    raw = new FileChannelWrapper(new FileOutputStream(this.coded).getChannel());
                    H264Utils.saveStreamParams(avcC, (SeekableByteChannel)raw);
                }
                raw.write(_rawData);
                decodedPics.add(decoder.decodeFrame(nalUnits, Picture.create(ine.getWidth() + 15 & 0xFFFFFFF0, ine.getHeight() + 15 & 0xFFFFFFF0, ColorSpace.YUV420).getData()));
                if (i % 500 == 0) {
                    System.out.println(i * 100 / totalFrames + "%");
                }
                ++i;
            }
            if (decodedPics.size() > 0) {
                this.runJMCompareResults(decodedPics, seqNo);
            }
        }
        finally {
            if (source != null) {
                source.close();
            }
            if (raw != null) {
                raw.close();
            }
        }
    }

    private void runJMCompareResults(List<Picture> decodedPics, int seqNo) throws Exception {
        try {
            Process process = Runtime.getRuntime().exec(this.jm + " -d " + this.jmconf.getAbsolutePath());
            process.waitFor();
            ByteBuffer yuv = NIOUtils.fetchFrom(this.decoded);
            for (Picture pic : decodedPics) {
                pic = pic.cropped();
                boolean equals = Arrays.equals(JCodecUtil.getAsIntArray(yuv, pic.getPlaneWidth(0) * pic.getPlaneHeight(0)), pic.getPlaneData(0));
                equals &= Arrays.equals(JCodecUtil.getAsIntArray(yuv, pic.getPlaneWidth(1) * pic.getPlaneHeight(1)), pic.getPlaneData(1));
                if (equals &= Arrays.equals(JCodecUtil.getAsIntArray(yuv, pic.getPlaneWidth(2) * pic.getPlaneHeight(2)), pic.getPlaneData(2))) continue;
                this.diff(seqNo);
            }
        }
        catch (Exception e) {
            this.diff(seqNo);
        }
    }

    private void diff(int seqNo) {
        System.out.println(seqNo + ": DIFF!!!");
        this.coded.renameTo(new File(this.errs, String.format("seq%08d.264", seqNo)));
        this.decoded.renameTo(new File(this.errs, String.format("seq%08d_dec.yuv", seqNo)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prepareJMConf() throws IOException {
        InputStream cool = null;
        try {
            cool = this.getClass().getClassLoader().getResourceAsStream("org/jcodec/testing/jm.conf");
            String str = IOUtils.toString(cool);
            str = str.replace("%input_file%", this.coded.getAbsolutePath());
            str = str.replace("%output_file%", this.decoded.getAbsolutePath());
            IOUtils.writeStringToFile(this.jmconf, str);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(cool);
            throw throwable;
        }
        IOUtils.closeQuietly(cool);
    }
}

