/*
 * Decompiled with CFR 0.152.
 */
package view25d.view;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.nlogo.api.Context;
import org.nlogo.api.LogoException;
import view25d.View25DExtension;
import view25d.view.MouseableGLWindow;
import view25d.view.VarviewDashboard;

public abstract class VarviewWindow
extends JFrame {
    private static final long serialVersionUID = 1L;
    public int worldWidth;
    public int worldHeight;
    public int minPxcor;
    public int minPycor;
    public int maxPxcor;
    public int maxPycor;
    public int xExpand;
    public int yExpand;
    public double zScale = 1.0;
    protected JPanel mainPanel;
    private VarviewDashboard dashboard;
    public static final int ORBIT = 0;
    public static final int MOVE = 1;
    public static final int ZOOM = 2;
    public static final int RESET = -1;
    public static final int SCALEZ = 3;
    private int mode = 0;

    public abstract void zoomZby(double var1);

    public abstract MouseableGLWindow getGLWindow();

    public void setMode(int newmode) {
        this.mode = newmode;
    }

    public int getMode() {
        return this.mode;
    }

    public VarviewWindow(String title) {
        super(title);
    }

    protected void setupUI() {
        this.dashboard = new VarviewDashboard(this);
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(new BorderLayout());
        this.mainPanel.add((Component)this.dashboard, "South");
        this.getContentPane().add(this.mainPanel);
    }

    protected void centerWindow(Component frame) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameSize = frame.getSize();
        if (frameSize.width > screenSize.width) {
            frameSize.width = screenSize.width;
        }
        if (frameSize.height > screenSize.height) {
            frameSize.height = screenSize.height;
        }
        int wincycle = 5;
        int widPlay = screenSize.width - frameSize.width;
        int heightPlay = screenSize.height - frameSize.height;
        int shiftWEach = widPlay / wincycle;
        int shiftHEach = heightPlay / wincycle;
        int numWins = View25DExtension.numWindows();
        int placeW = numWins % wincycle * shiftWEach + shiftWEach / 2;
        int placeH = numWins % wincycle * shiftHEach + shiftHEach / 2;
        frame.setLocation(placeW, placeH);
    }

    public abstract void resetPerspective();

    public abstract void manuallyRefreshReporterView(Context var1) throws LogoException;

    protected void applySquareConstraint(int xBorder, int yBorder, JPanel inner) {
        int chromeH = this.getHeight() - inner.getHeight();
        int w = inner.getWidth() - xBorder;
        int h = inner.getHeight() - yBorder;
        int constraint = Math.min(w, h);
        inner.setPreferredSize(new Dimension(constraint + xBorder, constraint + yBorder));
        this.setSize(new Dimension(constraint + xBorder, constraint + yBorder + chromeH));
        this.invalidate();
    }
}

