/*
 * Decompiled with CFR 0.152.
 */
package view25d.view.gl;

import com.jogamp.opengl.GL2;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.glu.GLU;
import com.jogamp.opengl.glu.GLUquadric;
import java.awt.Color;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import view25d.view.LinkValue;
import view25d.view.MouseableGLWindow;
import view25d.view.PatchValue;
import view25d.view.PatchView;
import view25d.view.TurtleValue;
import view25d.view.gl.Compilables;

public class PatchGL
extends MouseableGLWindow
implements GLEventListener {
    int patchTileListHandle;
    int patchThickTileListHandle;
    int patchStickListHandle;
    int sphereDotListHandle;
    int altThickPatchHandle;
    int axisHeadHandle;
    int patchDiskTileHandle;
    int patchSkyscraperHandle;
    int pinHeadListHandle;
    protected GLUquadric quadric;
    boolean colors = true;

    public PatchGL(PatchView parent) {
        super(parent);
    }

    private void setupCompiledDisplayLists(GL2 gl) {
        this.patchTileListHandle = gl.glGenLists(1);
        gl.glNewList(this.patchTileListHandle, 4864);
        Compilables.PatchTile(gl);
        gl.glEndList();
        this.patchStickListHandle = gl.glGenLists(1);
        gl.glNewList(this.patchStickListHandle, 4864);
        Compilables.PatchStickTile(gl, 10);
        gl.glEndList();
        this.patchThickTileListHandle = gl.glGenLists(1);
        gl.glNewList(this.patchThickTileListHandle, 4864);
        Compilables.ThickPatchTile(gl, 0.4f, 0.2f);
        gl.glEndList();
        this.sphereDotListHandle = gl.glGenLists(1);
        GLUquadric quadr = this.glu.gluNewQuadric();
        this.glu.gluQuadricDrawStyle(quadr, 100012);
        this.glu.gluQuadricNormals(quadr, 100000);
        float radius = 0.4f;
        int slices = 16;
        gl.glNewList(this.sphereDotListHandle, 4864);
        Compilables.PinHead(gl, this.glu, quadr, 0.4f, 16);
        gl.glEndList();
        this.altThickPatchHandle = gl.glGenLists(1);
        gl.glNewList(this.altThickPatchHandle, 4864);
        Compilables.ThickPatchTile(gl, 0.4f, 0.15f);
        Compilables.PinHead(gl, this.glu, quadr, 0.3f, 16);
        gl.glEndList();
        this.patchSkyscraperHandle = gl.glGenLists(1);
        gl.glNewList(this.patchSkyscraperHandle, 4864);
        Compilables.box(gl, 0.4f, 1.0f);
        gl.glEndList();
        this.axisHeadHandle = gl.glGenLists(1);
        gl.glNewList(this.axisHeadHandle, 4864);
        Compilables.AxisHead(gl, this.glu, quadr, 1.3, 16);
        gl.glEndList();
        this.patchDiskTileHandle = gl.glGenLists(1);
        gl.glNewList(this.patchDiskTileHandle, 4864);
        Compilables.DiskPatchTile(gl, this.glu, quadr, 0.4, 16);
        gl.glEndList();
        this.pinHeadListHandle = gl.glGenLists(1);
        gl.glNewList(this.pinHeadListHandle, 4864);
        Compilables.PinHead(gl, this.glu, quadr, 0.6f, 16);
        gl.glEndList();
        this.nlGLU.setQuadric(quadr);
        this.compileShapes(gl, this.compiledShapes, false);
        this.glu.gluDeleteQuadric(quadr);
    }

    public void display(GLAutoDrawable drawable) {
        int j;
        int i;
        GL2 gl = (GL2)drawable.getGL();
        if (this.areShapesStale) {
            this.compileShapes(gl, this.compiledShapes, false);
            this.setDeletedShapesToDefaultShape(this.compiledShapes);
            this.areShapesStale = false;
        }
        gl.glMatrixMode(5888);
        gl.glLoadIdentity();
        gl.glClear(16640);
        gl.glLineWidth(1.0f);
        this.setColorAndStandardMaterial(gl, 0.0f, 0.1f, 0.9f);
        gl.glPushMatrix();
        this.observer.applyPerspective(gl);
        if (((PatchView)this.myViewer).viewOptions.tangents() || !this.colors) {
            for (i = 0; i < this.myViewer.worldWidth; ++i) {
                for (j = 0; j < this.myViewer.worldHeight; ++j) {
                    gl.glPushMatrix();
                    gl.glTranslated((double)(i + this.myViewer.minPxcor), (double)(j + this.myViewer.minPycor), -0.01);
                    gl.glCallList(this.patchTileListHandle);
                    gl.glPopMatrix();
                }
            }
        }
        for (i = 0; i < this.myViewer.worldWidth; ++i) {
            for (j = 0; j < this.myViewer.worldHeight; ++j) {
                gl.glPushMatrix();
                PatchValue pv = ((PatchView)this.myViewer).reporterValueMatrix[i][j];
                double val = this.myViewer.zScale * pv.reporterValue;
                Color c = pv.color;
                gl.glTranslated((double)(i + this.myViewer.minPxcor), (double)(j + this.myViewer.minPycor), val);
                if (((PatchView)this.myViewer).viewOptions.sticks()) {
                    this.setColorAndStandardMaterial(gl, 0.6f, 0.6f, 0.6f);
                    gl.glLineWidth(0.1f);
                    gl.glBegin(1);
                    gl.glVertex3i(0, 0, 0);
                    gl.glVertex3d(0.0, 0.0, -val);
                    gl.glEnd();
                }
                if (this.colors) {
                    float red = (float)c.getRed() / 255.0f;
                    float green = (float)c.getGreen() / 255.0f;
                    float blue = (float)c.getBlue() / 255.0f;
                    this.setColorAndStandardMaterial(gl, red, green, blue);
                } else {
                    this.setColorAndStandardMaterial(gl, 0.0f, 0.9f, 0.1f);
                }
                if (((PatchView)this.myViewer).viewOptions.tangents()) {
                    if (j > 0 && j < this.myViewer.worldHeight - 1) {
                        double slopey = (((PatchView)this.myViewer).reporterValueMatrix[i][j + 1].reporterValue - ((PatchView)this.myViewer).reporterValueMatrix[i][j - 1].reporterValue) / 2.0;
                        double beta = 180.0 * Math.atan(slopey *= this.myViewer.zScale) / Math.PI;
                        gl.glRotated(beta, 1.0, 0.0, 0.0);
                    }
                    if (i > 0 && i < this.myViewer.worldWidth - 1) {
                        double slopex = (((PatchView)this.myViewer).reporterValueMatrix[i + 1][j].reporterValue - ((PatchView)this.myViewer).reporterValueMatrix[i - 1][j].reporterValue) / 2.0;
                        double alpha = 180.0 * Math.atan(slopex *= this.myViewer.zScale) / Math.PI;
                        gl.glRotated(-alpha, 0.0, 1.0, 0.0);
                    }
                    gl.glCallList(this.pinHeadListHandle);
                } else {
                    gl.glTranslated(0.0, 0.0, -val);
                    gl.glScaled(1.0, 1.0, val);
                    gl.glCallList(this.patchSkyscraperHandle);
                }
                gl.glPopMatrix();
            }
        }
        if (((PatchView)this.myViewer).viewOptions.structures()) {
            for (TurtleValue tv : ((PatchView)this.myViewer).turtleValues) {
                gl.glPushMatrix();
                try {
                    float red = (float)tv.color.getRed() / 255.0f;
                    float green = (float)tv.color.getGreen() / 255.0f;
                    float blue = (float)tv.color.getBlue() / 255.0f;
                    this.setColorAndStandardMaterial(gl, red, green, blue);
                    double zval = this.myViewer.zScale * tv.reporterValue;
                    if (zval < 0.0) {
                        gl.glTranslated(tv.xcor, tv.ycor, zval - 0.045);
                    } else {
                        gl.glTranslated(tv.xcor, tv.ycor, zval + 0.045);
                    }
                    gl.glScaled(tv.size, tv.size, tv.size);
                    gl.glScaled(3.0, 3.0, 3.0);
                    gl.glRotated(-1.0 * tv.heading, 0.0, 0.0, 1.0);
                    gl.glCallList(((Integer)this.compiledShapes.get(tv.shape)).intValue());
                }
                catch (ConcurrentModificationException cme) {
                    cme.printStackTrace();
                    throw cme;
                }
                catch (NullPointerException npe) {
                    npe.printStackTrace();
                    throw npe;
                }
                gl.glPopMatrix();
            }
            for (LinkValue lv : ((PatchView)this.myViewer).linkValues) {
                double zval1 = 0.0;
                double zval2 = 0.0;
                if (((PatchView)this.myViewer).viewOptions.linksAreThreeD()) {
                    zval1 = this.myViewer.zScale * lv.zcor1;
                    zval2 = this.myViewer.zScale * lv.zcor2;
                }
                Color c = lv.color;
                float linkRed = (float)c.getRed() / 255.0f;
                float linkGreen = (float)c.getGreen() / 255.0f;
                float linkBlue = (float)c.getBlue() / 255.0f;
                this.setColorAndStandardMaterial(gl, linkRed, linkGreen, linkBlue);
                if (lv.thickness == 0.0) {
                    lv.thickness = 0.1f;
                }
                gl.glLineWidth((float)lv.thickness);
                gl.glBegin(1);
                gl.glVertex3d(lv.xcor1, lv.ycor1, zval1);
                gl.glVertex3d(lv.xcor2, lv.ycor2, zval2);
                gl.glEnd();
            }
        }
        this.drawAxesIfDragging(gl, this.axisHeadHandle);
        gl.glPopMatrix();
    }

    public void init(GLAutoDrawable drawable) {
        this.compiledShapes = new HashMap();
        GL2 gl = (GL2)drawable.getGL();
        this.glu = new GLU();
        this.setupCompiledDisplayLists(gl);
        this.setupLightingAndViewPort(gl, this.glu);
    }

    public void dispose(GLAutoDrawable drawable) {
    }

    public void reshape(GLAutoDrawable drawable, int x, int y, int width, int height) {
    }
}

