/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jeuclid.awt;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import net.sourceforge.jeuclid.MutableLayoutContext;
import net.sourceforge.jeuclid.context.LayoutContextImpl;
import net.sourceforge.jeuclid.context.Parameter;
import net.sourceforge.jeuclid.layout.JEuclidView;
import org.w3c.dom.Document;

public class MathComponent
extends Component {
    private static final long serialVersionUID = 1L;
    private transient JEuclidView view;
    private Document document;
    private MutableLayoutContext parameters = new LayoutContextImpl(LayoutContextImpl.getDefaultLayoutContext());

    public final void setParameters(MutableLayoutContext mutableLayoutContext) {
        this.parameters = mutableLayoutContext;
    }

    public Document getDocument() {
        return this.document;
    }

    public Dimension getMinimumSize() {
        if (this.view == null) {
            return new Dimension(1, 1);
        }
        return new Dimension((int)Math.ceil(this.view.getWidth()), (int)Math.ceil(this.view.getAscentHeight() + (float)((int)Math.ceil(this.view.getDescentHeight()))));
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (this.view != null) {
            this.view.draw((Graphics2D)graphics, 0.0f, (int)Math.ceil(this.view.getAscentHeight()));
        }
    }

    private void redo() {
        Graphics2D graphics2D = (Graphics2D)this.getGraphics();
        this.view = this.document == null || graphics2D == null ? null : new JEuclidView(this.document, this.parameters, graphics2D);
        this.repaint();
    }

    public void setDebug(boolean bl) {
        this.parameters.setParameter(Parameter.DEBUG, bl);
        this.redo();
    }

    public void setDocument(Document document) {
        this.document = document;
        this.redo();
    }
}

