/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.content.animation.animator;

import cern.jet.random.Uniform;
import cern.jet.random.engine.MersenneTwister;
import cern.jet.random.engine.RandomEngine;
import org.openimaj.content.animation.animator.LinearDoubleValueAnimator;
import org.openimaj.content.animation.animator.ValueAnimator;

public class RandomLinearDoubleValueAnimator
implements ValueAnimator<Double> {
    private int seed;
    Uniform rng;
    LinearDoubleValueAnimator animator;
    private double min;
    private double max;
    private int duration;

    public RandomLinearDoubleValueAnimator(double min, double max, int duration) {
        this.seed = (int)System.nanoTime();
        this.min = min;
        this.max = max;
        this.duration = duration;
        this.reset();
    }

    public RandomLinearDoubleValueAnimator(double min, double max, int duration, double initial) {
        this(min, max, duration);
        this.setNextAnimator(initial);
    }

    public RandomLinearDoubleValueAnimator(int startWait, int stopWait, double min, double max, int duration) {
        this.seed = (int)System.currentTimeMillis();
        this.min = min;
        this.max = max;
        this.duration = duration;
        this.reset();
    }

    public RandomLinearDoubleValueAnimator(int startWait, int stopWait, double min, double max, int duration, double initial) {
        this(min, max, duration);
        this.setNextAnimator(initial);
    }

    @Override
    public Double nextValue() {
        if (this.animator.hasFinished()) {
            this.setNextAnimator((Double)this.animator.nextValue());
        }
        return (Double)this.animator.nextValue();
    }

    @Override
    public boolean hasFinished() {
        return false;
    }

    @Override
    public void reset() {
        this.rng = new Uniform((RandomEngine)new MersenneTwister(this.seed));
        double v1 = this.rng.nextDoubleFromTo(this.min, this.max);
        this.setNextAnimator(v1);
    }

    protected void setNextAnimator(double v1) {
        double v2 = this.rng.nextDoubleFromTo(this.min, this.max);
        this.animator = new LinearDoubleValueAnimator(v1, v2, this.duration);
    }
}

