/*
 * Decompiled with CFR 0.152.
 */
package bsearch.test;

import bsearch.algorithms.SearchMethod;
import bsearch.algorithms.SearchMethodLoader;
import bsearch.algorithms.SearchParameterException;
import bsearch.app.BehaviorSearch;
import bsearch.app.BehaviorSearchException;
import bsearch.app.SearchProtocol;
import bsearch.nlogolink.ModelRunner;
import bsearch.nlogolink.NetLogoLinkException;
import bsearch.nlogolink.Utils;
import bsearch.representations.Chromosome;
import bsearch.representations.ChromosomeFactory;
import bsearch.representations.ChromosomeTypeLoader;
import bsearch.representations.GrayBinaryChromosome;
import bsearch.representations.StandardBinaryChromosome;
import bsearch.space.SearchSpace;
import bsearch.util.GeneralUtils;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.nlogo.api.MersenneTwisterFast;
import org.nlogo.api.Version$;
import org.xml.sax.SAXException;

public strictfp class BehaviorSearchTest {
    public static final String DEFAULT_MODEL_PATH = "/home/forrest/apps/NetLogo 6.0.1/app/models/Sample Models/";

    public static void main(String ... args) {
        JUnitCore.main((String[])new String[]{BehaviorSearchTest.class.getName()});
    }

    public String sampleModelsPath() {
        String osName = System.getProperty("os.name");
        String netLogoVersion = Version$.MODULE$.version();
        if (osName.contains("Mac")) {
            return "/Applications/" + netLogoVersion + "/models/Sample Models/";
        }
        if (osName.contains("Win")) {
            return "C:\\Program Files\\" + netLogoVersion + "/app/models/Sample Models/";
        }
        return DEFAULT_MODEL_PATH;
    }

    @Test
    public void testModelRunner1() throws Exception {
        ModelRunner runner = ModelRunner.createModelRunnerForTesting(this.sampleModelsPath() + "Earth Science/Fire.nlogo", true, 100);
        runner.setSetupCommands("setup");
        runner.setStepCommands("go");
        runner.setStopConditionReporter("burned-trees > 3000");
        runner.setMeasureIfReporter("ticks mod 10 = 0 or ticks = 37");
        runner.addResultReporter("burned-trees");
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("density", 61.0);
        ModelRunner.RunSetup runSetup = new ModelRunner.RunSetup(0, params);
        LinkedList<Double> results = runner.doFullRun(runSetup).getTimeSeriesForMeasure("burned-trees");
        Assert.assertEquals((long)5L, (long)results.size());
        Assert.assertEquals((double)3002.0, (double)((Double)results.get(results.size() - 1)), (double)0.001);
        Assert.assertEquals((Object)37.0, (Object)runner.report("ticks"));
        runner.command("go");
        Assert.assertEquals((Object)3068.0, (Object)runner.measureResults().get("burned-trees"));
        runner.dispose();
    }

    @Test
    public void testModelRunner2() throws Exception {
        ModelRunner runner = ModelRunner.createModelRunnerForTesting(this.sampleModelsPath() + "Earth Science/Fire.nlogo", false, 100);
        runner.setSetupCommands("setup");
        runner.setStepCommands("go");
        runner.setStopConditionReporter("burned-trees > 3000");
        runner.setMeasureIfReporter("true");
        runner.addResultReporter("burned-trees");
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("density", 61.0);
        runner.setup(0, params);
        for (int i = 0; i < 100 && !runner.go(); ++i) {
        }
        Assert.assertEquals((Object)3002.0, (Object)runner.measureResults().get("burned-trees"));
        Assert.assertEquals((Object)37.0, (Object)runner.report("ticks"));
        runner.dispose();
    }

    @Test
    public void testConstraintsTextGeneration() throws BehaviorSearchException, NetLogoLinkException {
        Assert.assertEquals((Object)Utils.getDefaultConstraintsText(this.sampleModelsPath() + "/Social Science/Ethnocentrism.nlogo").trim(), (Object)"[\"mutation-rate\" [0 0.001 1]]\n[\"death-rate\" [0 0.05 1]]\n[\"immigrants-per-day\" [0 1 100]]\n[\"initial-ptr\" [0 0.01 1]]\n[\"cost-of-giving\" [0 0.01 1]]\n[\"gain-of-receiving\" [0 0.01 1]]\n[\"immigrant-chance-cooperate-with-same\" [0 0.01 1]]\n[\"immigrant-chance-cooperate-with-different\" [0 0.01 1]]");
    }

    @Test
    public void testSearchProtocol() throws IOException, SAXException {
        String FILENAME = GeneralUtils.attemptResolvePathFromBSearchRoot("test/TestProtocol.xml");
        SearchProtocol sp = SearchProtocol.loadFile(FILENAME);
        StringWriter sw = new StringWriter();
        sp.save(new PrintWriter(sw));
        String result = sw.getBuffer().toString().replaceAll("\\s", "");
        String original = GeneralUtils.stringContentsOfFile(new File(FILENAME)).replaceAll("\\s", "");
        Assert.assertEquals((Object)result, (Object)original);
    }

    @Test
    public void testSearchMethodLoader() throws BehaviorSearchException {
        for (String s : SearchMethodLoader.getAllSearchMethodNames()) {
            SearchMethod searcher = SearchMethodLoader.createFromName(s);
            searcher.getSearchParams().toString();
        }
    }

    @Test
    public void testChromosomes() throws BehaviorSearchException {
        SearchSpace ss = new SearchSpace(Arrays.asList("[\"discrete1to4\" [1 1 4]]", "[\"continuous0to1.5\" [0.0 \"C\" 1.5]]", "[\"categorical\" \"apple\" \"banana\" \"cherry\"]", "[\"const\" 25]", "[\"discretedecimal\" [-1 0.17 2]]"));
        MersenneTwisterFast rng = new MersenneTwisterFast();
        for (String chromoType : ChromosomeTypeLoader.getAllChromosomeTypes()) {
            int i;
            ChromosomeFactory factory = ChromosomeTypeLoader.createFromName(chromoType);
            Chromosome[] cs = new Chromosome[]{factory.createChromosome(ss, rng), factory.createChromosome(ss, rng)};
            for (i = 0; i < 1000; ++i) {
                cs[0] = cs[0].mutate(0.2, rng);
                cs[1] = cs[1].crossoverWith(cs[0], rng)[0];
                for (Chromosome c : cs) {
                    LinkedHashMap<String, Object> params = c.getParamSettings();
                    double val1 = (Double)params.get("discrete1to4");
                    double val2 = (Double)params.get("continuous0to1.5");
                    String val3 = (String)params.get("categorical");
                    Object val4 = params.get("const");
                    double val5 = (Double)params.get("discretedecimal");
                    Assert.assertTrue((String)(chromoType + " check val1 >= 1"), (val1 >= 1.0 ? 1 : 0) != 0);
                    Assert.assertTrue((String)(chromoType + " check val1 <= 4"), (val1 <= 4.0 ? 1 : 0) != 0);
                    Assert.assertTrue((String)(chromoType + " check val2 >= 0.0"), (val2 >= 0.0 ? 1 : 0) != 0);
                    Assert.assertTrue((String)(chromoType + " check val2 <= 1.5"), (val2 <= 1.5 ? 1 : 0) != 0);
                    Assert.assertTrue((String)(chromoType + " check val3 okay"), (val3.equals("apple") || val3.equals("banana") || val3.equals("cherry") ? 1 : 0) != 0);
                    Assert.assertTrue((String)(chromoType + " check val4 okay"), (boolean)val4.equals(25.0));
                    Assert.assertTrue((String)(chromoType + " check val5 >= -1"), (val5 >= -1.0 ? 1 : 0) != 0);
                    Assert.assertTrue((String)(chromoType + " check val5 <= 2"), (val5 <= 2.0 ? 1 : 0) != 0);
                }
            }
            for (i = 0; i < 10000; ++i) {
                Chromosome c = factory.createChromosome(ss, rng);
                Chromosome c2 = factory.createChromosome(ss, c.getParamSettings());
                Assert.assertEquals((String)(chromoType + " check recreate Chromosomes from values:"), c.getParamSettings(), c2.getParamSettings());
            }
        }
    }

    @Test
    public void testBinaryConversion() {
        long dec;
        long i;
        int numBits = 8;
        boolean[] bits = new boolean[numBits + 12];
        SearchSpace ss = new SearchSpace(Arrays.asList("[\"moo\" [1 1 4]]"));
        GrayBinaryChromosome bcgray = new GrayBinaryChromosome(ss, new MersenneTwisterFast());
        StandardBinaryChromosome bcstd = new StandardBinaryChromosome(ss, new MersenneTwisterFast());
        for (i = 0L; i < 1L << numBits; ++i) {
            bcgray.binaryEncode(i, bits, 5, numBits);
            dec = bcgray.binaryDecode(bits, 5, numBits);
            Assert.assertEquals((long)i, (long)dec);
            bcstd.binaryEncode(i, bits, 5, numBits);
            dec = bcstd.binaryDecode(bits, 5, numBits);
            Assert.assertEquals((long)i, (long)dec);
        }
        numBits = 62;
        bits = new boolean[numBits + 3];
        for (i = 0L; i < 1L << numBits; i += 15037093017331L) {
            bcgray.binaryEncode(i, bits, 2, numBits);
            dec = bcgray.binaryDecode(bits, 2, numBits);
            Assert.assertEquals((long)i, (long)dec);
            bcstd.binaryEncode(i, bits, 2, numBits);
            dec = bcstd.binaryDecode(bits, 2, numBits);
            Assert.assertEquals((long)i, (long)dec);
        }
    }

    public static <T> String join(Iterable<T> objs, String delimiter) {
        Iterator<T> iter = objs.iterator();
        if (!iter.hasNext()) {
            return "";
        }
        StringBuffer buffer = new StringBuffer(String.valueOf(iter.next()));
        while (iter.hasNext()) {
            buffer.append(delimiter).append(String.valueOf(iter.next()));
        }
        return buffer.toString();
    }

    @Test
    public void testConsistentOutputResults() throws IOException, SAXException, SearchParameterException, BehaviorSearchException, InterruptedException, CmdLineException {
        Path tmpDirectory = Paths.get("test/tmp", new String[0]);
        Files.createDirectories(tmpDirectory, new FileAttribute[0]);
        LinkedHashMap<String, String> scenarios = new LinkedHashMap<String, String>();
        scenarios.put("TesterSuperRandom", "-p test/TesterSuperRandom.bsearch -o test/tmp/TesterSuperRandom -t 7 -n 2 --randomseed 123 --quiet");
        scenarios.put("Tester1", "-p test/Tester.bsearch -o test/tmp/Tester1 -t 1 -n 2 -f 3 --randomseed 1234 --quiet");
        scenarios.put("Tester2", "-p test/Tester.bsearch -o test/tmp/Tester2 -t 2 -n 3 -f 10 --randomseed 99 --quiet");
        scenarios.put("TesterNoisy", "-p test/TesterNoisy.bsearch -o test/tmp/TesterNoisy -t 2 -n 2 --randomseed 123 --quiet");
        scenarios.put("TesterGANoCache", "-p test/TesterGANoCache.bsearch -o test/tmp/TesterGANoCache -n 1 -t 2 --randomseed 99 --quiet");
        scenarios.put("TesterSA_Deriv", "-p test/TesterSA_Deriv.bsearch -o test/tmp/TesterSA_Deriv -n 2 -t 1 --randomseed 67 --quiet");
        scenarios.put("TesterNoisy_RS", "-p test/TesterNoisy_RS.bsearch -o test/tmp/TesterNoisy_RS -t 1 -n 1 --randomseed 123 --quiet");
        scenarios.put("TesterNoisy_RS", "-p test/TesterNoisy_RS.bsearch -o test/tmp/TesterNoisy_RS -t 5 -n 1 --randomseed 123 --quiet");
        List<String> outputExtensions = Arrays.asList(".searchConfig.xml", ".modelRunHistory.csv", ".objectiveFunctionHistory.csv", ".bestHistory.csv", ".finalBests.csv", ".finalCheckedBests.csv");
        ArrayList<String> failedList = new ArrayList<String>();
        for (String key : scenarios.keySet()) {
            BehaviorSearch.RunOptions clOptions = new BehaviorSearch.RunOptions();
            CmdLineParser parser = new CmdLineParser((Object)clOptions);
            parser.parseArgument(((String)scenarios.get(key)).split("\\s"));
            BehaviorSearch.runWithOptions(clOptions);
            for (String extension : outputExtensions) {
                String checkFileName = GeneralUtils.attemptResolvePathFromBSearchRoot("test/checks/" + key + extension);
                String testFileName = GeneralUtils.attemptResolvePathFromBSearchRoot("test/tmp/" + key + extension);
                File checkFile = new File(checkFileName);
                File testFile = new File(testFileName);
                String expected = checkFile.exists() ? GeneralUtils.stringContentsOfFile(checkFile) : "*no_file*";
                String result = testFile.exists() ? GeneralUtils.stringContentsOfFile(testFile) : "*no_file*";
                if (result.equals(expected)) continue;
                failedList.add(key + extension);
            }
        }
        if (!failedList.isEmpty()) {
            Assert.fail((String)("Output files that differ: " + BehaviorSearchTest.join(failedList, ", ")));
        }
    }
}

