/*
 * Decompiled with CFR 0.152.
 */
package org.myworldgis.projection;

import com.vividsolutions.jts.geom.Coordinate;
import java.text.ParseException;
import org.myworldgis.projection.Cylindrical;
import org.myworldgis.projection.Ellipsoid;
import org.myworldgis.projection.ProjectionParameters;
import org.myworldgis.util.GeometryUtils;
import org.ngs.ngunits.SI;
import org.ngs.ngunits.Unit;
import org.ngs.ngunits.quantity.Angle;
import org.ngs.ngunits.quantity.Length;

public strictfp final class Miller
extends Cylindrical {
    public static final String WKT_NAME = "Miller_Cylindrical";
    public static final String CENTER_LON_PROPERTY = "longitude_of_center";
    public static final String CENTER_LAT_PROPERTY = "latitude_of_center";

    public Miller(Ellipsoid ellipsoid, Coordinate center, Unit<Length> units, double falseEasting, double falseNorthing) {
        super(ellipsoid, center, units, falseEasting, falseNorthing);
        this._name = WKT_NAME;
        this.computeParameters();
    }

    public Miller(Ellipsoid ellipsoid, ProjectionParameters parameters) throws ParseException {
        super(ellipsoid, parameters);
        this._name = WKT_NAME;
        this.computeParameters();
    }

    @Override
    protected Coordinate forwardPointRaw(double lon, double lat, Coordinate storage) {
        storage.x = this._a * GeometryUtils.wrap_longitude(lon - this._lambda0);
        storage.y = this._a * GeometryUtils.asinh(StrictMath.tan(0.8 * lat)) / 0.8;
        return storage;
    }

    @Override
    protected Coordinate inversePointRaw(double x, double y, Coordinate storage) {
        storage.x = x / this._a + this._lambda0;
        storage.y = StrictMath.atan(GeometryUtils.sinh(0.8 * y / this._a)) / 0.8;
        return storage;
    }

    @Override
    public ProjectionParameters getParameters() {
        ProjectionParameters result = super.getParameters();
        result.addAngularParameter(CENTER_LON_PROPERTY, this._lambda0, (Unit<Angle>)SI.RADIAN);
        result.addAngularParameter(CENTER_LAT_PROPERTY, this._phi0, (Unit<Angle>)SI.RADIAN);
        return result;
    }
}

