/*
 * Decompiled with CFR 0.152.
 */
package org.la4j.vector.dense;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.la4j.vector.AbstractVector;
import org.la4j.vector.Vector;
import org.la4j.vector.Vectors;
import org.la4j.vector.dense.DenseSafeVector;
import org.la4j.vector.dense.DenseVector;
import org.la4j.vector.source.VectorSource;

public class BasicVector
extends AbstractVector
implements DenseVector {
    private static final long serialVersionUID = 4071505L;
    private double[] self;

    public BasicVector() {
        this(0);
    }

    public BasicVector(Vector vector) {
        this(Vectors.asUnsafeSource(vector));
    }

    public BasicVector(VectorSource source) {
        this(source.length());
        for (int i = 0; i < this.length; ++i) {
            this.self[i] = source.get(i);
        }
    }

    public BasicVector(int length) {
        this(new double[length]);
    }

    public BasicVector(double[] array) {
        super(Vectors.BASIC_FACTORY, array.length);
        this.self = array;
    }

    @Override
    public double get(int i) {
        return this.self[i];
    }

    @Override
    public void set(int i, double value) {
        this.self[i] = value;
    }

    @Override
    public void swap(int i, int j) {
        if (i == j) {
            return;
        }
        double d = this.self[i];
        this.self[i] = this.self[j];
        this.self[j] = d;
    }

    @Override
    public Vector copy() {
        return this.resize(this.length);
    }

    @Override
    public Vector resize(int length) {
        this.ensureLengthIsNotNegative(length);
        double[] $self = new double[length];
        System.arraycopy(this.self, 0, $self, 0, Math.min($self.length, this.self.length));
        return new BasicVector($self);
    }

    @Override
    public double[] toArray() {
        double[] result = new double[this.length];
        System.arraycopy(this.self, 0, result, 0, this.length);
        return result;
    }

    @Override
    public Vector safe() {
        return new DenseSafeVector(this);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.length);
        for (int i = 0; i < this.length; ++i) {
            out.writeDouble(this.self[i]);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.length = in.readInt();
        this.self = new double[this.length];
        for (int i = 0; i < this.length; ++i) {
            this.self[i] = in.readDouble();
        }
    }
}

