/*
 * Decompiled with CFR 0.152.
 */
package org.ngs.ngunits.converter;

import org.ngs.ngunits.UnitConverter;
import org.ngs.ngunits.converter.AbstractUnitConverter;
import org.ngs.ngunits.converter.MultiplyConverter;

public final class RationalConverter
extends AbstractUnitConverter {
    private final long _dividend;
    private final long _divisor;

    private static long gcd(long l, long l2) {
        if (l2 == 0L) {
            return l;
        }
        return RationalConverter.gcd(l2, l % l2);
    }

    public RationalConverter(long l, long l2) {
        if (l2 < 0L) {
            throw new IllegalArgumentException("Negative divisor");
        }
        if (l == l2) {
            throw new IllegalArgumentException("Identity converter not allowed");
        }
        this._dividend = l;
        this._divisor = l2;
    }

    public long getDividend() {
        return this._dividend;
    }

    public long getDivisor() {
        return this._divisor;
    }

    public UnitConverter concatenate(UnitConverter unitConverter) {
        if (unitConverter instanceof RationalConverter) {
            long l;
            RationalConverter rationalConverter = (RationalConverter)unitConverter;
            long l2 = this._dividend * rationalConverter._dividend;
            long l3 = this._divisor * rationalConverter._divisor;
            double d = (double)this._dividend * (double)rationalConverter._dividend;
            double d2 = (double)this._divisor * (double)rationalConverter._divisor;
            if ((double)l2 != d || (double)l3 != d2) {
                double d3 = d / d2;
                if ((float)d3 == 1.0f) {
                    return IDENTITY;
                }
                return new MultiplyConverter(d3);
            }
            if ((l2 /= (l = RationalConverter.gcd(l2, l3))) == (l3 /= l)) {
                return IDENTITY;
            }
            return new RationalConverter(l2, l3);
        }
        if (unitConverter instanceof MultiplyConverter) {
            return unitConverter.concatenate(this);
        }
        return super.concatenate(unitConverter);
    }

    public double convert(double d) {
        return d * (double)this._dividend / (double)this._divisor;
    }

    public UnitConverter inverse() {
        if (this._dividend < 0L) {
            return new RationalConverter(-this._divisor, -this._dividend);
        }
        return new RationalConverter(this._divisor, this._dividend);
    }
}

