/*
 * Decompiled with CFR 0.152.
 */
package org.opencv.android;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.util.Log;
import org.opencv.android.InstallCallbackInterface;
import org.opencv.android.LoaderCallbackInterface;

public abstract class BaseLoaderCallback
implements LoaderCallbackInterface {
    protected Context mAppContext;
    private static final String TAG = "OpenCVLoader/BaseLoaderCallback";

    public BaseLoaderCallback(Context AppContext) {
        this.mAppContext = AppContext;
    }

    @Override
    public void onManagerConnected(int status) {
        switch (status) {
            case 0: {
                break;
            }
            case 2: {
                Log.e((String)TAG, (String)"Package installation failed!");
                AlertDialog MarketErrorMessage = new AlertDialog.Builder(this.mAppContext).create();
                MarketErrorMessage.setTitle((CharSequence)"OpenCV Manager");
                MarketErrorMessage.setMessage((CharSequence)"Package installation failed!");
                MarketErrorMessage.setCancelable(false);
                MarketErrorMessage.setButton(-1, (CharSequence)"OK", new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                        BaseLoaderCallback.this.finish();
                    }
                });
                MarketErrorMessage.show();
                break;
            }
            case 3: {
                Log.d((String)TAG, (String)"OpenCV library installation was canceled by user");
                this.finish();
                break;
            }
            case 4: {
                Log.d((String)TAG, (String)"OpenCV Manager Service is uncompatible with this app!");
                AlertDialog IncomatibilityMessage = new AlertDialog.Builder(this.mAppContext).create();
                IncomatibilityMessage.setTitle((CharSequence)"OpenCV Manager");
                IncomatibilityMessage.setMessage((CharSequence)"OpenCV Manager service is incompatible with this app. Try to update it via Google Play.");
                IncomatibilityMessage.setCancelable(false);
                IncomatibilityMessage.setButton(-1, (CharSequence)"OK", new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                        BaseLoaderCallback.this.finish();
                    }
                });
                IncomatibilityMessage.show();
                break;
            }
            default: {
                Log.e((String)TAG, (String)"OpenCV loading failed!");
                AlertDialog InitFailedDialog = new AlertDialog.Builder(this.mAppContext).create();
                InitFailedDialog.setTitle((CharSequence)"OpenCV error");
                InitFailedDialog.setMessage((CharSequence)"OpenCV was not initialised correctly. Application will be shut down");
                InitFailedDialog.setCancelable(false);
                InitFailedDialog.setButton(-1, (CharSequence)"OK", new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                        BaseLoaderCallback.this.finish();
                    }
                });
                InitFailedDialog.show();
            }
        }
    }

    @Override
    public void onPackageInstall(int operation, final InstallCallbackInterface callback) {
        switch (operation) {
            case 0: {
                AlertDialog InstallMessage = new AlertDialog.Builder(this.mAppContext).create();
                InstallMessage.setTitle((CharSequence)"Package not found");
                InstallMessage.setMessage((CharSequence)(callback.getPackageName() + " package was not found! Try to install it?"));
                InstallMessage.setCancelable(false);
                InstallMessage.setButton(-1, (CharSequence)"Yes", new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                        callback.install();
                    }
                });
                InstallMessage.setButton(-2, (CharSequence)"No", new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                        callback.cancel();
                    }
                });
                InstallMessage.show();
                break;
            }
            case 1: {
                AlertDialog WaitMessage = new AlertDialog.Builder(this.mAppContext).create();
                WaitMessage.setTitle((CharSequence)"OpenCV is not ready");
                WaitMessage.setMessage((CharSequence)"Installation is in progress. Wait or exit?");
                WaitMessage.setCancelable(false);
                WaitMessage.setButton(-1, (CharSequence)"Wait", new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                        callback.wait_install();
                    }
                });
                WaitMessage.setButton(-2, (CharSequence)"Exit", new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                        callback.cancel();
                    }
                });
                WaitMessage.show();
            }
        }
    }

    void finish() {
        ((Activity)this.mAppContext).finish();
    }
}

