/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.extensions.profiler;

import java.util.Vector;

public class CallRecord {
    public String name;
    public long jobID;
    public long contextID;
    public String agent;
    public long startTime;
    public long stopTime;
    public CallRecord caller;
    public Vector<CallRecord> called;
    public String[] argDescriptions;

    public CallRecord(String name, String agent, String[] argDescriptions) {
        this.name = name;
        this.agent = agent;
        this.argDescriptions = argDescriptions;
        this.called = new Vector();
    }

    public long exclusiveTime() {
        long base = this.inclusiveTime();
        int calledSize = this.called.size();
        for (int i = 0; i < calledSize; ++i) {
            base -= this.called.get(i).inclusiveTime();
        }
        return base;
    }

    public long inclusiveTime() {
        return this.stopTime - this.startTime;
    }

    public String toString() {
        return "CallRecord[" + this.name + "][" + this.agent + "] " + this.inclusiveTime() + " " + this.startTime + "/" + this.stopTime + ")";
    }
}

