/*
 * Decompiled with CFR 0.152.
 */
package org.hid4java;

import org.hid4java.HidDeviceManager;
import org.hid4java.jna.HidApi;
import org.hid4java.jna.HidDeviceInfoStructure;
import org.hid4java.jna.HidDeviceStructure;

public class HidDevice {
    private final HidDeviceManager hidDeviceManager;
    private HidDeviceStructure hidDeviceStructure;
    private String path;
    private short vendorId;
    private short productId;
    private String serialNumber;
    private int releaseNumber;
    private String manufacturer;
    private String product;
    private int usagePage;
    private int usage;
    private int interfaceNumber;

    public HidDevice(HidDeviceInfoStructure infoStructure, HidDeviceManager hidDeviceManager) {
        this.hidDeviceManager = hidDeviceManager;
        this.hidDeviceStructure = null;
        this.path = infoStructure.path;
        this.vendorId = infoStructure.vendor_id;
        this.productId = infoStructure.product_id;
        this.releaseNumber = infoStructure.release_number;
        if (infoStructure.serial_number != null) {
            this.serialNumber = infoStructure.serial_number.toString();
        }
        if (infoStructure.manufacturer_string != null) {
            this.manufacturer = infoStructure.manufacturer_string.toString();
        }
        if (infoStructure.product_string != null) {
            this.product = infoStructure.product_string.toString();
        }
        this.usagePage = infoStructure.usage_page;
        this.usage = infoStructure.usage;
        this.interfaceNumber = infoStructure.interface_number;
    }

    public String getId() {
        return this.path;
    }

    public String getPath() {
        return this.path;
    }

    public short getVendorId() {
        return this.vendorId;
    }

    public short getProductId() {
        return this.productId;
    }

    public String getSerialNumber() {
        return this.serialNumber;
    }

    public int getReleaseNumber() {
        return this.releaseNumber;
    }

    public String getManufacturer() {
        return this.manufacturer;
    }

    public String getProduct() {
        return this.product;
    }

    public int getUsagePage() {
        return this.usagePage;
    }

    public int getUsage() {
        return this.usage;
    }

    public int getInterfaceNumber() {
        return this.interfaceNumber;
    }

    public boolean open() {
        this.hidDeviceStructure = HidApi.open(this.path);
        return this.hidDeviceStructure != null;
    }

    public boolean isOpen() {
        return this.hidDeviceStructure != null;
    }

    public void close() {
        if (!this.isOpen()) {
            return;
        }
        HidApi.close(this.hidDeviceStructure);
        this.hidDeviceStructure = null;
    }

    public void setNonBlocking(boolean nonBlocking) {
        if (!this.isOpen()) {
            throw new IllegalStateException("Device has not been opened");
        }
        HidApi.setNonBlocking(this.hidDeviceStructure, nonBlocking);
    }

    public int read(byte[] data) {
        if (!this.isOpen()) {
            throw new IllegalStateException("Device has not been opened");
        }
        return HidApi.read(this.hidDeviceStructure, data);
    }

    public int read(byte[] bytes, int timeoutMillis) {
        if (!this.isOpen()) {
            throw new IllegalStateException("Device has not been opened");
        }
        return HidApi.read(this.hidDeviceStructure, bytes, timeoutMillis);
    }

    public int getFeatureReport(byte[] data, byte reportId) {
        if (!this.isOpen()) {
            throw new IllegalStateException("Device has not been opened");
        }
        return HidApi.getFeatureReport(this.hidDeviceStructure, data, reportId);
    }

    public int sendFeatureReport(byte[] data, byte reportId) {
        if (!this.isOpen()) {
            throw new IllegalStateException("Device has not been opened");
        }
        return HidApi.sendFeatureReport(this.hidDeviceStructure, data, reportId);
    }

    public String getIndexedString(int index) {
        return HidApi.getIndexedString(this.hidDeviceStructure, index);
    }

    public int write(byte[] message, int packetLength, byte reportId) {
        if (!this.isOpen()) {
            throw new IllegalStateException("Device has not been opened");
        }
        int result = HidApi.write(this.hidDeviceStructure, message, packetLength, reportId);
        this.hidDeviceManager.afterDeviceWrite();
        return result;
    }

    public String getLastErrorMessage() {
        return HidApi.getLastErrorMessage(this.hidDeviceStructure);
    }

    public boolean isVidPidSerial(int vendorId, int productId, String serialNumber) {
        return !(vendorId != 0 && this.vendorId != vendorId || productId != 0 && this.productId != productId || serialNumber != null && !this.serialNumber.equals(serialNumber));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HidDevice hidDevice = (HidDevice)o;
        return this.path.equals(hidDevice.path);
    }

    public int hashCode() {
        return this.path.hashCode();
    }

    public String toString() {
        return "HidDevice [path=" + this.path + ", vendorId=0x" + Integer.toHexString(this.vendorId) + ", productId=0x" + Integer.toHexString(this.productId) + ", serialNumber=" + this.serialNumber + ", releaseNumber=0x" + Integer.toHexString(this.releaseNumber) + ", manufacturer=" + this.manufacturer + ", product=" + this.product + ", usagePage=0x" + Integer.toHexString(this.usagePage) + ", usage=0x" + Integer.toHexString(this.usage) + ", interfaceNumber=" + this.interfaceNumber + "]";
    }
}

