/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.hubnet.mirroring;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.nlogo.api.Color;
import org.nlogo.api.Dump;
import org.nlogo.core.LogoList;
import org.nlogo.hubnet.mirroring.AgentData;

public strictfp final class PatchData
extends AgentData {
    public static final short DEAD = 0;
    public static final short PCOLOR = 1;
    public static final short PLABEL = 2;
    public static final short PLABEL_COLOR = 4;
    public static final short PXCOR = 8;
    public static final short PYCOR = 16;
    public static final short COMPLETE = 31;
    private final long id;
    private LogoList pcolor;
    private String plabel = "";
    private LogoList plabelColor;
    private int pxcor;
    private int pycor;
    private short mask;
    int[] patchColors;
    private static final String[] OVERRIDE_VARIABLES = new String[]{"PCOLOR", "PLABEL", "PLABEL-COLOR"};
    private static final String[] OVERRIDE_METHODS = new String[]{"pcolor", "plabel", "plabelColor"};

    PatchData(long id, short mask, int pxcor, int pycor, Object pcolor, String plabel, Object plabelColor) {
        this.id = id;
        this.pxcor = pxcor;
        this.pycor = pycor;
        this.mask = mask;
        this.pcolor(pcolor);
        this.plabel = plabel;
        this.plabelColor(plabelColor);
    }

    PatchData(DataInputStream is) throws IOException {
        this.id = is.readLong();
        this.mask = is.readShort();
        if ((this.mask & 8) == 8) {
            this.pxcor = is.readInt();
        }
        if ((this.mask & 0x10) == 16) {
            this.pycor = is.readInt();
        }
        if ((this.mask & 1) == 1) {
            this.pcolor(is.readInt());
        }
        if ((this.mask & 2) == 2) {
            this.plabel = is.readUTF();
        }
        if ((this.mask & 4) == 4) {
            this.plabelColor(is.readInt());
        }
    }

    private PatchData(long id) {
        this.id = id;
        this.mask = 0;
    }

    public long id() {
        return this.id;
    }

    public int pxcor() {
        return this.pxcor;
    }

    public int pycor() {
        return this.pycor;
    }

    public Object pcolor() {
        return this.pcolor;
    }

    public void pcolor(Object pcolor) {
        if (pcolor instanceof Double) {
            this.pcolor((Double)pcolor);
        } else {
            this.pcolor((LogoList)pcolor);
        }
    }

    private void pcolor(Double pcolor) {
        this.pcolor(Color.getARGBbyPremodulatedColorNumber(pcolor));
    }

    private void pcolor(LogoList pcolor) {
        this.pcolor = pcolor;
        if (this.patchColors != null) {
            this.patchColors[(int)this.id] = Color.getARGBIntByRGBAList(pcolor);
        }
    }

    private void pcolor(int argb) {
        this.pcolor = Color.getRGBAListByARGB(argb);
        if (this.patchColors != null) {
            this.patchColors[(int)this.id] = argb;
        }
    }

    public String plabel() {
        return this.plabel;
    }

    public void plabel(Object plabel) {
        this.plabel = Dump.logoObject(plabel);
    }

    public Object plabelColor() {
        return this.plabelColor;
    }

    public void plabelColor(Object plabelColor) {
        if (plabelColor instanceof Double) {
            this.plabelColor((Double)plabelColor);
        } else {
            this.plabelColor((LogoList)plabelColor);
        }
    }

    public void plabelColor(Double plabelColor) {
        this.plabelColor(Color.getARGBbyPremodulatedColorNumber(plabelColor));
    }

    public void plabelColor(LogoList plabelColor) {
        this.plabelColor = plabelColor;
    }

    public void plabelColor(int argb) {
        this.plabelColor(Color.getRGBAListByARGB(argb));
    }

    public boolean hasLabel() {
        return this.plabel.length() > 0;
    }

    @Override
    public String getMethodName(int index) {
        return OVERRIDE_METHODS[index];
    }

    public static int getOverrideIndex(String varName) {
        return PatchData.getOverrideIndex(OVERRIDE_VARIABLES, varName);
    }

    @Override
    public double xcor() {
        return this.pxcor;
    }

    @Override
    public double ycor() {
        return this.pycor;
    }

    @Override
    public double spotlightSize() {
        return 1.0;
    }

    @Override
    public boolean wrapSpotlight() {
        return false;
    }

    String stringRep() {
        return "Patch " + this.pxcor + " " + this.pycor + " (" + Color.getARGBIntByRGBAList(this.pcolor) + ", " + this.plabel + ", " + Color.getARGBIntByRGBAList(this.plabelColor) + ")";
    }

    boolean isComplete() {
        return (this.mask & 0x1F) == 31;
    }

    PatchData updateFrom(PatchData otherPatch) {
        PatchData diffs = new PatchData(this.id);
        if ((otherPatch.mask & 8) == 8 && this.pxcor != otherPatch.pxcor) {
            this.pxcor = otherPatch.pxcor;
            diffs.mask = (short)(diffs.mask | 8);
            diffs.pxcor = this.pxcor;
        }
        if ((otherPatch.mask & 0x10) == 16 && this.pycor != otherPatch.pycor) {
            this.pycor = otherPatch.pycor;
            diffs.mask = (short)(diffs.mask | 0x10);
            diffs.pycor = this.pycor;
        }
        if ((otherPatch.mask & 1) == 1 && !this.pcolor.equals(otherPatch.pcolor)) {
            this.pcolor = otherPatch.pcolor;
            diffs.mask = (short)(diffs.mask | 1);
            diffs.pcolor = this.pcolor;
        }
        if ((otherPatch.mask & 2) == 2 && !this.plabel.equals(otherPatch.plabel)) {
            this.plabel = otherPatch.plabel;
            diffs.mask = (short)(diffs.mask | 2);
            diffs.plabel = this.plabel;
        }
        if ((otherPatch.mask & 4) == 4 && !this.plabelColor.equals(otherPatch.plabelColor)) {
            this.plabelColor(otherPatch.plabelColor);
            diffs.mask = (short)(diffs.mask | 4);
            diffs.plabelColor = this.plabelColor;
        }
        if (diffs.mask != 0) {
            return diffs;
        }
        return null;
    }

    void serialize(DataOutputStream os) throws IOException {
        os.writeLong(this.id);
        os.writeShort(this.mask);
        if ((this.mask & 8) == 8) {
            os.writeInt(this.pxcor);
        }
        if ((this.mask & 0x10) == 16) {
            os.writeInt(this.pycor);
        }
        if ((this.mask & 1) == 1) {
            os.writeInt(Color.getARGBIntByRGBAList(this.pcolor));
        }
        if ((this.mask & 2) == 2) {
            os.writeUTF(this.plabel);
        }
        if ((this.mask & 4) == 4) {
            os.writeInt(Color.getARGBIntByRGBAList(this.plabelColor));
        }
    }
}

