/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.mc;

import java.awt.Frame;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JDialog;
import org.apache.http.client.HttpClient;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.nlogo.mc.Group;
import org.nlogo.mc.LoadingDialog;
import org.nlogo.mc.PostRequest;

public strictfp abstract class DownloadGroupsRequest
extends PostRequest {
    private Frame frame;
    private JDialog loadingDialog;

    public DownloadGroupsRequest(HttpClient http, Frame frame) {
        super(http, "http://modelingcommons.org/account/list_groups");
        this.frame = frame;
    }

    @Override
    protected void onReturn(String response) {
        this.loadingDialog.dispose();
        if (response == null) {
            this.onDownloaded("CONNECTION_ERROR", null);
            return;
        }
        JSONParser json = new JSONParser();
        try {
            ArrayList<Group> newGroups = new ArrayList<Group>();
            JSONObject obj = (JSONObject)json.parse(response);
            JSONArray groupsArr = (JSONArray)obj.get((Object)"groups");
            for (Object groupObj : groupsArr) {
                JSONObject group = (JSONObject)groupObj;
                int id = ((Number)group.get((Object)"id")).intValue();
                String name = (String)group.get((Object)"name");
                newGroups.add(new Group(id, name));
            }
            this.onDownloaded("SUCCESS", newGroups);
        }
        catch (ParseException e) {
            this.onDownloaded("INVALID_RESPONSE_FROM_SERVER", null);
        }
    }

    @Override
    public void execute() {
        this.loadingDialog = new LoadingDialog(this.frame, "Loading groups you belong to");
        super.execute();
        this.loadingDialog.setVisible(true);
    }

    protected abstract void onDownloaded(String var1, List<Group> var2);
}

