/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.mc;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.nlogo.awt.Hierarchy;
import org.nlogo.awt.UserCancelException;
import org.nlogo.swing.FileDialog;

public strictfp class FileSelector
extends JPanel {
    private static final String NO_FILE_SELECTED = "No file selected";
    private String filePath;
    private JButton selectFileButton;
    private JLabel filePathLabel;
    private JPanel filePathLabelPanel;
    private JComponent parent;

    public FileSelector(JComponent parent) {
        this.setLayout(new BoxLayout(this, 0));
        this.setForeground(Color.BLUE);
        this.parent = parent;
        JPanel buttonPanel = new JPanel();
        this.selectFileButton = new JButton("Select File");
        this.add(Box.createRigidArea(new Dimension(10, 0)));
        this.add(this.selectFileButton);
        this.add(Box.createRigidArea(new Dimension(10, 0)));
        this.filePathLabelPanel = new JPanel(new BorderLayout());
        this.filePathLabel = new JLabel(NO_FILE_SELECTED);
        this.filePathLabelPanel.add((Component)this.filePathLabel, "Center");
        this.add(this.filePathLabelPanel);
        this.selectFileButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    FileSelector.this.filePath = FileDialog.showFiles(Hierarchy.getFrame(FileSelector.this), "Select image to use as preview image", 0);
                    FileSelector.this.resizeSelectedFileLabel();
                }
                catch (UserCancelException userCancelException) {
                    // empty catch block
                }
            }
        });
        parent.addComponentListener(new ComponentListener(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                FileSelector.this.resizeSelectedFileLabel();
            }

            @Override
            public void componentMoved(ComponentEvent componentEvent) {
            }

            @Override
            public void componentShown(ComponentEvent componentEvent) {
            }

            @Override
            public void componentHidden(ComponentEvent componentEvent) {
            }
        });
    }

    @Override
    public void setEnabled(boolean enable) {
        this.filePathLabel.setEnabled(enable);
        this.selectFileButton.setEnabled(enable);
    }

    private void resizeSelectedFileLabel() {
        if (this.filePath != null) {
            String toSet = this.filePath;
            FontMetrics metrics = this.filePathLabel.getFontMetrics(this.filePathLabel.getFont());
            double availableWidth = this.filePathLabelPanel.getVisibleRect().getWidth();
            System.out.println(availableWidth);
            while (toSet.length() > 2 && (double)metrics.stringWidth(toSet) > availableWidth) {
                toSet = "\u2026" + toSet.substring(2);
            }
            this.filePathLabel.setText(toSet);
        }
    }

    public String getFilePath() {
        return this.filePath;
    }
}

