/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.nvm;

import java.awt.image.BufferedImage;
import java.net.MalformedURLException;
import org.nlogo.agent.AgentSet;
import org.nlogo.agent.ImportPatchColors;
import org.nlogo.api.Agent;
import org.nlogo.api.Exceptions;
import org.nlogo.api.LogoException;
import org.nlogo.api.MersenneTwisterFast;
import org.nlogo.api.World;
import org.nlogo.nvm.Activation;
import org.nlogo.nvm.Command;
import org.nlogo.nvm.ConcurrentJob;
import org.nlogo.nvm.EngineException;
import org.nlogo.nvm.ExclusiveJob;
import org.nlogo.nvm.HaltException;
import org.nlogo.nvm.Instruction;
import org.nlogo.nvm.Job;
import org.nlogo.nvm.NetLogoStackOverflow;
import org.nlogo.nvm.NonLocalExit;
import org.nlogo.nvm.Reporter;
import org.nlogo.nvm.StackTraceBuilder;
import org.nlogo.nvm.Workspace;
import scala.Option;

public strictfp final class Context
implements org.nlogo.api.Context {
    public final Job job;
    public org.nlogo.agent.Agent myself;
    public org.nlogo.agent.Agent agent;
    public int agentBit;
    public int ip;
    public Activation activation;
    public boolean waiting = false;
    private Workspace workspace;
    private boolean inReporterProcedure = false;
    public boolean stopping = false;
    public boolean finished = false;

    public Context(Job job, org.nlogo.agent.Agent agent, int ip, Activation activation) {
        this.job = job;
        this.agent = agent;
        if (agent != null) {
            this.agentBit = agent.agentBit();
        }
        this.ip = ip;
        this.activation = activation;
    }

    public Context(Job job, org.nlogo.agent.Agent agent, int ip, Activation activation, Workspace workspace) {
        this.job = job;
        this.agent = agent;
        if (agent != null) {
            this.agentBit = agent.agentBit();
        }
        this.ip = ip;
        this.activation = activation;
        this.workspace = workspace;
    }

    public Context(Context context, AgentSet agents) {
        this.job = context.job;
        this.activation = context.activation;
        this.myself = context.agent;
        this.agentBit = agents.agentBit();
    }

    public Context(Context context, org.nlogo.agent.Agent agent) {
        this.job = context.job;
        this.activation = context.activation;
        this.myself = context.agent;
        this.agentBit = agent.agentBit();
    }

    public Context copy() {
        return new Context(this.job, this.agent, this.ip, this.activation);
    }

    public boolean makeChildrenExclusive() {
        return this.inReporterProcedure || this.job.exclusive();
    }

    void stepConcurrent() {
        if (this.agent._id == -1L) {
            this.finished = true;
            return;
        }
        Command command = null;
        try {
            do {
                command = this.activation.code[this.ip];
                if ((this.agentBit & command.agentBits) == 0) {
                    command.throwAgentClassException(this, this.agent.kind());
                }
                command.perform(this);
                if (!command.world.comeUpForAir) continue;
                this.comeUpForAir(command);
            } while (!command.switches && !this.finished);
        }
        catch (LogoException ex) {
            EngineException.rethrow(ex, this.copy(), command);
        }
        catch (StackOverflowError ex) {
            throw new NetLogoStackOverflow((org.nlogo.api.Context)this.copy(), this.activation.code[this.ip], ex);
        }
    }

    void runExclusive() {
        if (this.agent._id == -1L) {
            this.finished = true;
            return;
        }
        Command command = null;
        try {
            do {
                command = this.activation.code[this.ip];
                if ((this.agentBit & command.agentBits) == 0) {
                    command.throwAgentClassException(this, this.agent.kind());
                }
                command.perform(this);
                if (!command.world.comeUpForAir) continue;
                this.comeUpForAir(command);
            } while (!this.finished);
        }
        catch (LogoException ex) {
            EngineException.rethrow(ex, this.copy(), command);
        }
    }

    public boolean hasParentContext() {
        return this.job.parentContext != null;
    }

    public org.nlogo.agent.Agent myself() {
        if (this.myself == null) {
            if (this.job.parentContext == null) {
                return null;
            }
            this.myself = this.job.parentContext.agent;
        }
        return this.myself;
    }

    public boolean atTopActivation() {
        return this.job.parentContext == null || this.activation != this.job.parentContext.activation;
    }

    public void runExclusiveJob(AgentSet agentset, int address) {
        new ExclusiveJob(this.job.owner, agentset, this.activation.procedure, address, this, this.workspace, this.job.random).run();
        if (this.agent._id == -1L) {
            this.finished = true;
        }
    }

    public Job makeConcurrentJob(AgentSet agentset) {
        return new ConcurrentJob(this.job.owner, agentset, null, this.ip + 1, this, this.workspace, this.job.random);
    }

    public void returnFromProcedure() {
        this.ip = this.activation.returnAddress;
        this.activation = this.activation.parent;
    }

    public void stop() {
        if (this.activation.procedure.isLambda()) {
            throw new NonLocalExit();
        }
        if (this.activation.procedure.topLevel()) {
            this.job.stopping = true;
            this.finished = true;
        }
        this.returnFromProcedure();
        this.stopping = true;
    }

    public Object evaluateReporter(org.nlogo.agent.Agent agent, Reporter reporter) throws LogoException {
        this.agent = agent;
        return reporter.report(this);
    }

    public Object callReporterProcedure(Activation newActivation) throws LogoException {
        boolean oldInReporterProcedure = this.inReporterProcedure;
        Command command = null;
        this.inReporterProcedure = true;
        this.activation = newActivation;
        this.ip = 0;
        try {
            do {
                command = this.activation.code[this.ip];
                if ((this.agentBit & command.agentBits) == 0) {
                    command.throwAgentClassException(this, this.agent.kind());
                }
                command.perform(this);
                if (!command.world.comeUpForAir) continue;
                this.comeUpForAir(command);
            } while (!this.finished && this.job.result == null);
        }
        catch (NonLocalExit nonLocalExit) {
        }
        catch (LogoException ex) {
            EngineException.rethrow(ex, this.copy(), command);
        }
        catch (StackOverflowError ex) {
            throw new NetLogoStackOverflow((org.nlogo.api.Context)this.copy(), this.activation.code[this.ip], ex);
        }
        finally {
            this.inReporterProcedure = oldInReporterProcedure;
            this.ip = this.activation.returnAddress;
            this.activation = this.activation.parentOrNull();
        }
        Object result = this.job.result;
        this.job.result = null;
        return result;
    }

    public void runtimeError(Exception ex) {
        try {
            Instruction instruction = null;
            Context context = null;
            if (ex instanceof EngineException) {
                instruction = ((EngineException)ex).responsibleInstructionOrNull();
                context = (Context)((EngineException)ex).context();
            }
            if (instruction == null) {
                instruction = this.activation.code[this.ip];
            }
            if (context == null) {
                context = this;
            }
            instruction.workspace.runtimeError(this.job.owner, context, instruction, ex);
        }
        catch (RuntimeException ex2) {
            Exceptions.handle(ex);
        }
    }

    public String buildRuntimeErrorMessage(Instruction instruction, Throwable throwable) {
        return this.buildRuntimeErrorMessage(instruction, throwable, null);
    }

    public String buildRuntimeErrorMessage(Instruction instruction, Throwable throwable, String message) {
        if (throwable instanceof EngineException) {
            return ((EngineException)throwable).runtimeErrorMessage();
        }
        return StackTraceBuilder.build(this.activation, this.agent, instruction, Option.apply(throwable), message);
    }

    private void comeUpForAir(Command command) throws HaltException {
        if (command.switches && this.job.owner.ownsPrimaryJobs()) {
            command.workspace.breathe(this);
        }
        if (Thread.currentThread().isInterrupted()) {
            command.world.comeUpForAir = false;
            this.finished = true;
            throw new HaltException(true);
        }
    }

    @Override
    public Workspace workspace() {
        return this.workspace;
    }

    @Override
    public Activation activation() {
        return this.activation;
    }

    @Override
    public MersenneTwisterFast getRNG() {
        return this.job.random;
    }

    @Override
    public String attachCurrentDirectory(String path) throws MalformedURLException {
        return this.workspace.fileManager().attachPrefix(path);
    }

    @Override
    public void importPcolors(BufferedImage image, boolean asNetLogoColors) {
        ImportPatchColors.doImport(image, this.workspace.world(), asNetLogoColors);
    }

    @Override
    public BufferedImage getDrawing() {
        return this.workspace.getAndCreateDrawing();
    }

    @Override
    public World world() {
        return this.workspace.world();
    }

    @Override
    public Agent getAgent() {
        return this.agent;
    }
}

