/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.shape;

import java.awt.Color;
import java.awt.Point;
import java.io.Serializable;
import org.nlogo.core.Shape;
import org.nlogo.shape.Circle;
import org.nlogo.shape.Element;
import org.nlogo.shape.Line;
import org.nlogo.shape.LinkLine;
import org.nlogo.shape.LinkShape;
import org.nlogo.shape.Polygon;
import org.nlogo.shape.Rectangle;
import org.nlogo.shape.VectorShape;
import scala.Function1;
import scala.MatchError;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;

public final class ShapeConverter$ {
    public static ShapeConverter$ MODULE$;

    static {
        new ShapeConverter$();
    }

    public Shape baseShapeToShape(Shape bs) {
        Shape shape;
        if (bs instanceof Shape.VectorShape) {
            Shape.VectorShape vectorShape = (Shape.VectorShape)bs;
            shape = this.baseVectorShapeToVectorShape(vectorShape);
        } else if (bs instanceof Shape.LinkShape) {
            Shape.LinkShape linkShape = (Shape.LinkShape)bs;
            shape = this.baseLinkShapeToLinkShape(linkShape);
        } else {
            throw new MatchError(bs);
        }
        return shape;
    }

    /*
     * WARNING - void declaration
     */
    public LinkShape baseLinkShapeToLinkShape(Shape.LinkShape l) {
        void var2_2;
        LinkShape ls = new LinkShape();
        ls.name_$eq(l.name());
        ls.curviness_$eq(l.curviness());
        ls.directionIndicator_$eq(this.baseVectorShapeToVectorShape(l.indicator()));
        ((IterableLike)l.linkLines().zipWithIndex(Seq$.MODULE$.canBuildFrom())).foreach((Function1<Tuple2, Object> & Serializable & scala.Serializable)x0$1 -> {
            ShapeConverter$.$anonfun$baseLinkShapeToLinkShape$1(ls, x0$1);
            return BoxedUnit.UNIT;
        });
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public VectorShape baseVectorShapeToVectorShape(Shape.VectorShape v) {
        void var2_2;
        VectorShape vs = new VectorShape();
        vs.name_$eq(v.name());
        vs.setRotatable(v.rotatable());
        vs.setEditableColorIndex(v.editableColorIndex());
        v.elements().map((Function1<Shape.Element, Object> & Serializable & scala.Serializable)e -> {
            vs.add(ShapeConverter$.MODULE$.coreElementToElement(e));
            return BoxedUnit.UNIT;
        }, Seq$.MODULE$.canBuildFrom());
        return var2_2;
    }

    public Color color(Shape.RgbColor c) {
        return new Color(c.red(), c.green(), c.blue(), c.alpha());
    }

    public Point point(Tuple2<Object, Object> t) {
        return new Point(t._1$mcI$sp(), t._2$mcI$sp());
    }

    public Element coreElementToElement(Shape.Element e) {
        Element element;
        if (e instanceof Shape.Line) {
            Shape.Line line = (Shape.Line)e;
            Line line2 = new Line(this.point(line.startPoint()), this.point(line.endPoint()), this.color(line.color()));
            line2.marked_$eq(line.marked());
            element = line2;
        } else if (e instanceof Shape.Polygon) {
            Shape.Polygon polygon = (Shape.Polygon)e;
            Polygon poly = new Polygon(polygon.xCoords().toList(), polygon.yCoords().toList(), this.color(polygon.color()));
            poly.filled_$eq(polygon.filled());
            poly.marked_$eq(polygon.marked());
            element = poly;
        } else if (e instanceof Shape.Circle) {
            Shape.Circle circle = (Shape.Circle)e;
            Circle circle2 = new Circle(circle.x(), circle.y(), circle.diameter(), this.color(circle.color()));
            circle2.filled_$eq(circle.filled());
            circle2.marked_$eq(circle.marked());
            element = circle2;
        } else if (e instanceof Shape.Rectangle) {
            Shape.Rectangle rectangle = (Shape.Rectangle)e;
            Rectangle rect = new Rectangle(this.point(rectangle.upperLeftCorner()), this.point(rectangle.lowerRightCorner()), this.color(rectangle.color()));
            rect.filled_$eq(rectangle.filled());
            rect.marked_$eq(rectangle.marked());
            element = rect;
        } else {
            throw new MatchError(e);
        }
        return element;
    }

    /*
     * WARNING - void declaration
     */
    public LinkLine coreLinkLineToLinkLine(Shape.LinkLine l) {
        void var2_2;
        LinkLine ll = new LinkLine(l.xcor(), l.isVisible());
        ll.dashes_$eq((float[])l.dashChoices().toArray(ClassTag$.MODULE$.Float()));
        return var2_2;
    }

    public static final /* synthetic */ void $anonfun$baseLinkShapeToLinkShape$1(LinkShape ls$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            Shape.LinkLine ll = (Shape.LinkLine)x0$1._1();
            int i = x0$1._2$mcI$sp();
            ls$1.add(i, new LinkLine(ll.xcor(), ll.isVisible(), (float[])ll.dashChoices().toArray(ClassTag$.MODULE$.Float())));
            return;
        }
        throw new MatchError((Object)null);
    }

    private ShapeConverter$() {
        MODULE$ = this;
    }
}

