"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getMinSagitta = exports.getSagitta = void 0;
var common_1 = require("../../../../utils/common");
var LIMITING_ANGLE = Math.PI / 2;
var controllingAngle = function () {
    var angles = [];
    for (var _i = 0; _i < arguments.length; _i++) {
        angles[_i] = arguments[_i];
    }
    return angles.reduce(function (limitAngle, a) {
        if (a >= Math.PI / 2 && a <= (3 / 2) * Math.PI) {
            var newA = Math.abs(a - Math.PI / 2);
            return Math.max(limitAngle, newA);
        }
        if (a >= -Math.PI / 2 && a <= Math.PI / 2) {
            var newA = Math.abs(a - Math.PI / 2);
            return Math.max(limitAngle, newA);
        }
        return limitAngle;
    }, LIMITING_ANGLE);
};
function getSagitta(angle, radius, fractionDigits) {
    if (fractionDigits === void 0) { fractionDigits = 1; }
    var arcLength = angle * radius;
    var halfCord = radius * Math.sin(arcLength / (2 * radius));
    var lengthMiltiplier = arcLength > Math.PI ? 1 : -1;
    var sagitta = radius + lengthMiltiplier * Math.sqrt(Math.pow(radius, 2) - Math.pow(halfCord, 2));
    return (0, common_1.round)(sagitta, fractionDigits);
}
exports.getSagitta = getSagitta;
function getMinSagitta(startAngle, endAngle, radius, fractionDigits) {
    var limitingAngle = controllingAngle(startAngle, endAngle);
    return getSagitta(limitingAngle * 2, radius, fractionDigits);
}
exports.getMinSagitta = getMinSagitta;
//# sourceMappingURL=utils.js.map