"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.render = void 0;
var common_1 = require("../../../../utils/common");
var viewmodel_1 = require("../../layout/viewmodel/viewmodel");
var mapConfigToTheme = function (_a) {
    var _b = _a === void 0 ? {} : _a, margin = _b.margin, backgroundColor = _b.backgroundColor, minFontSize = _b.minFontSize, maxFontSize = _b.maxFontSize, fontFamily = _b.fontFamily;
    return ({
        chartMargins: margin,
        background: { color: backgroundColor },
        goal: {
            minFontSize: minFontSize,
            maxFontSize: maxFontSize,
            tickLabel: { fontFamily: fontFamily },
            majorLabel: { fontFamily: fontFamily },
            minorLabel: { fontFamily: fontFamily },
        },
    });
};
function render(spec, parentDimensions, theme) {
    var _a, _b;
    var mergedTheme = (0, common_1.mergePartial)(theme, mapConfigToTheme(spec.config));
    var mergedSpec = (0, common_1.mergePartial)(spec, {
        angleEnd: (_a = spec === null || spec === void 0 ? void 0 : spec.config) === null || _a === void 0 ? void 0 : _a.angleEnd,
        angleStart: (_b = spec === null || spec === void 0 ? void 0 : spec.config) === null || _b === void 0 ? void 0 : _b.angleStart,
    });
    return (0, viewmodel_1.shapeViewModel)(mergedSpec, mergedTheme, parentDimensions);
}
exports.render = render;
//# sourceMappingURL=scenegraph.js.map