"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getPickedCells = void 0;
var create_selector_1 = require("../../../../state/create_selector");
var get_last_drag_1 = require("../../../../state/selectors/get_last_drag");
var compute_chart_dimensions_1 = require("./compute_chart_dimensions");
var geometries_1 = require("./geometries");
var get_grid_full_height_1 = require("./get_grid_full_height");
exports.getPickedCells = (0, create_selector_1.createCustomCachedSelector)([geometries_1.geometries, get_last_drag_1.getLastDragSelector, compute_chart_dimensions_1.computeChartDimensionsSelector, get_grid_full_height_1.getGridHeightParamsSelector], function (geoms, dragState, canvasDimensions, gridParams) {
    if (!dragState) {
        return null;
    }
    if (dragState.start.position.x < canvasDimensions.left && dragState.end.position.x < canvasDimensions.left) {
        var fittedDragStateStart = { x: canvasDimensions.left, y: dragState.start.position.y };
        var _a = geoms.pickDragArea([fittedDragStateStart, dragState.end.position]), y = _a.y, cells = _a.cells;
        return { x: [], y: y, cells: cells };
    }
    if (dragState.start.position.y > gridParams.gridCellHeight * gridParams.pageSize &&
        dragState.end.position.y > gridParams.gridCellHeight * gridParams.pageSize) {
        var fittedDragStateStart = { x: dragState.start.position.x, y: canvasDimensions.height };
        var _b = geoms.pickDragArea([fittedDragStateStart, dragState.end.position]), x = _b.x, cells = _b.cells;
        return { x: x, y: [], cells: cells };
    }
    return geoms.pickDragArea([dragState.start.position, dragState.end.position]);
});
//# sourceMappingURL=get_picked_cells.js.map