"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AbstractEmsService = void 0;
var _origin = require("./origin");
var _utils = require("./utils");
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
class AbstractEmsService {
  constructor(config, emsClient, proxyPath) {
    _defineProperty(this, "_emsClient", void 0);
    _defineProperty(this, "_config", void 0);
    _defineProperty(this, "_proxyPath", void 0);
    /**
     * Checks if url is absolute. If not, prepend the basePath.
     */
    _defineProperty(this, "_getAbsoluteUrl", url => {
      if (/^https?:\/\//.test(url)) {
        return url;
      } else {
        return (0, _utils.toAbsoluteUrl)(this.getApiUrl(), url);
      }
    });
    this._config = config;
    this._emsClient = emsClient;
    this._proxyPath = proxyPath;
  }
  getAttributions() {
    return this._config.attribution.map(attribution => {
      const url = this._emsClient.getValueInLanguage(attribution.url);
      const label = this._emsClient.getValueInLanguage(attribution.label);
      return {
        url: url,
        label: label
      };
    });
  }
  getMarkdownAttribution() {
    const attributions = this._config.attribution.map(attribution => {
      const url = this._emsClient.getValueInLanguage(attribution.url);
      const label = this._emsClient.getValueInLanguage(attribution.label);
      return `[${label}](${url})`;
    });
    return attributions.join('|');
  }
  getOrigin() {
    return _origin.ORIGIN.EMS;
  }
}
exports.AbstractEmsService = AbstractEmsService;