function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
import React, { useState } from 'react';
import { EuiI18n } from '../../i18n';
import { EuiPopover } from '../../popover';
import { EuiButtonEmpty, EuiButtonGroup } from '../../button';
export var startingStyles = {
  cellPadding: 'm',
  fontSize: 'm',
  border: 'all',
  stripes: false,
  rowHover: 'highlight',
  header: 'shade',
  footer: 'overline',
  stickyFooter: true
};
var densityStyles = {
  expanded: {
    fontSize: 'l',
    cellPadding: 'l'
  },
  normal: {
    fontSize: 'm',
    cellPadding: 'm'
  },
  compact: {
    fontSize: 's',
    cellPadding: 's'
  }
};
export var useDataGridStyleSelector = function useDataGridStyleSelector(initialStyles) {
  // track styles specified by the user at run time
  var _useState = useState({}),
      _useState2 = _slicedToArray(_useState, 2),
      userGridStyles = _useState2[0],
      setUserGridStyles = _useState2[1];

  var _useState3 = useState(false),
      _useState4 = _slicedToArray(_useState3, 2),
      isOpen = _useState4[0],
      setIsOpen = _useState4[1]; // These are the available options. They power the gridDensity hook and also the options in the render


  var densityOptions = ['expanded', 'normal', 'compact']; // Normal is the default density

  var _useState5 = useState(densityOptions[1]),
      _useState6 = _slicedToArray(_useState5, 2),
      gridDensity = _useState6[0],
      _setGridDensity = _useState6[1];

  var setGridDensity = function setGridDensity(density) {
    _setGridDensity(density);

    setUserGridStyles(densityStyles[density]);
  }; // merge the developer-specified styles with any user overrides


  var gridStyles = _objectSpread(_objectSpread({}, initialStyles), userGridStyles);

  var styleSelector = /*#__PURE__*/React.createElement(EuiPopover, {
    "data-test-subj": "dataGridStyleSelectorPopover",
    isOpen: isOpen,
    closePopover: function closePopover() {
      return setIsOpen(false);
    },
    anchorPosition: "downCenter",
    panelPaddingSize: "s",
    panelClassName: "euiDataGridColumnSelectorPopover",
    button: /*#__PURE__*/React.createElement(EuiButtonEmpty, {
      size: "xs",
      iconType: "tableDensityExpanded",
      className: "euiDataGrid__controlBtn",
      color: "text",
      "data-test-subj": "dataGridStyleSelectorButton",
      onClick: function onClick() {
        return setIsOpen(!isOpen);
      }
    }, /*#__PURE__*/React.createElement(EuiI18n, {
      token: "euiStyleSelector.buttonText",
      default: "Density"
    }))
  }, /*#__PURE__*/React.createElement(EuiI18n, {
    tokens: ['euiStyleSelector.buttonLegend', 'euiStyleSelector.labelExpanded', 'euiStyleSelector.labelNormal', 'euiStyleSelector.labelCompact'],
    defaults: ['Select the display density for the data grid', 'Expanded density', 'Normal density', 'Compact density']
  }, function (_ref) {
    var _ref2 = _slicedToArray(_ref, 4),
        buttonLegend = _ref2[0],
        labelExpanded = _ref2[1],
        labelNormal = _ref2[2],
        labelCompact = _ref2[3];

    return /*#__PURE__*/React.createElement(EuiButtonGroup, {
      legend: buttonLegend,
      name: "density",
      className: "eui-displayInlineBlock",
      buttonSize: "compressed",
      options: [{
        id: densityOptions[0],
        label: labelExpanded,
        iconType: 'tableDensityExpanded'
      }, {
        id: densityOptions[1],
        label: labelNormal,
        iconType: 'tableDensityNormal'
      }, {
        id: densityOptions[2],
        label: labelCompact,
        iconType: 'tableDensityCompact'
      }],
      onChange: setGridDensity,
      idSelected: gridDensity,
      isIconOnly: true
    });
  }));
  return [styleSelector, gridStyles];
};