"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiKeyPadMenuItem = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _classnames = _interopRequireDefault(require("classnames"));

var _beta_badge = require("../badge/beta_badge");

var _services = require("../../services");

var _form = require("../form");

var _href_validator = require("../../services/security/href_validator");

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
var EuiKeyPadMenuItem = function EuiKeyPadMenuItem(_ref) {
  var id = _ref.id,
      isSelected = _ref.isSelected,
      _isDisabled = _ref.isDisabled,
      label = _ref.label,
      children = _ref.children,
      className = _ref.className,
      betaBadgeLabel = _ref.betaBadgeLabel,
      betaBadgeTooltipContent = _ref.betaBadgeTooltipContent,
      betaBadgeIconType = _ref.betaBadgeIconType,
      href = _ref.href,
      rel = _ref.rel,
      target = _ref.target,
      buttonRef = _ref.buttonRef,
      checkable = _ref.checkable,
      name = _ref.name,
      value = _ref.value,
      disabled = _ref.disabled,
      _onChange = _ref.onChange,
      rest = (0, _objectWithoutProperties2.default)(_ref, ["id", "isSelected", "isDisabled", "label", "children", "className", "betaBadgeLabel", "betaBadgeTooltipContent", "betaBadgeIconType", "href", "rel", "target", "buttonRef", "checkable", "name", "value", "disabled", "onChange"]);
  var isHrefValid = !href || (0, _href_validator.validateHref)(href);
  var isDisabled = disabled || _isDisabled || !isHrefValid;
  var classes = (0, _classnames.default)('euiKeyPadMenuItem', {
    'euiKeyPadMenuItem--hasBetaBadge': betaBadgeLabel,
    'euiKeyPadMenuItem--checkable': checkable,
    'euiKeyPadMenuItem-isDisabled': isDisabled,
    'euiKeyPadMenuItem-isSelected': isSelected
  }, className);
  var Element = href && !isDisabled ? 'a' : 'button';
  if (checkable) Element = 'label';
  var itemId = (0, _services.useGeneratedHtmlId)({
    conditionalId: id
  });

  var renderCheckableElement = function renderCheckableElement() {
    if (!checkable) return;
    var inputClasses = (0, _classnames.default)('euiKeyPadMenuItem__checkableInput');
    var checkableElement;

    if (checkable === 'single') {
      checkableElement = /*#__PURE__*/_react.default.createElement(_form.EuiRadio, {
        id: itemId,
        className: inputClasses,
        checked: isSelected,
        disabled: isDisabled,
        name: name,
        value: value,
        onChange: function onChange() {
          return _onChange(itemId, value);
        }
      });
    } else {
      checkableElement = /*#__PURE__*/_react.default.createElement(_form.EuiCheckbox, {
        id: itemId,
        className: inputClasses,
        checked: isSelected,
        disabled: isDisabled,
        name: name,
        onChange: function onChange() {
          return _onChange(itemId);
        }
      });
    }

    return checkableElement;
  };

  var renderBetaBadge = function renderBetaBadge() {
    if (!betaBadgeLabel) return;
    return /*#__PURE__*/_react.default.createElement(_beta_badge.EuiBetaBadge, {
      size: "s",
      color: "subdued",
      className: "euiKeyPadMenuItem__betaBadge",
      label: betaBadgeLabel.charAt(0),
      title: betaBadgeLabel,
      iconType: betaBadgeIconType,
      tooltipContent: betaBadgeTooltipContent
    });
  };

  var renderContent = function renderContent() {
    return /*#__PURE__*/_react.default.createElement("span", {
      className: "euiKeyPadMenuItem__inner"
    }, checkable ? renderCheckableElement() : renderBetaBadge(), /*#__PURE__*/_react.default.createElement("span", {
      className: "euiKeyPadMenuItem__icon"
    }, children), /*#__PURE__*/_react.default.createElement("span", {
      className: "euiKeyPadMenuItem__label"
    }, label));
  };

  var relObj = {};

  if (href && !isDisabled) {
    relObj.href = href;
    relObj.rel = (0, _services.getSecureRelForTarget)({
      href: href,
      target: target,
      rel: rel
    });
    relObj.target = target;
    relObj['aria-current'] = isSelected ? isSelected : undefined;
  } else if (checkable) {
    relObj.htmlFor = itemId;
  } else {
    relObj.disabled = isDisabled;
    relObj.type = 'button';
    relObj['aria-pressed'] = isSelected;
  }

  return /*#__PURE__*/_react.default.createElement(Element, (0, _extends2.default)({
    className: classes
  }, relObj, rest, {
    // Unable to get past `LegacyRef` conflicts
    ref: buttonRef
  }), renderContent());
};

exports.EuiKeyPadMenuItem = EuiKeyPadMenuItem;
EuiKeyPadMenuItem.propTypes = {
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,

  /**
     * One will be generated if not provided
     */

  /**
     * One will be generated if not provided
     */

  /**
     * One will be generated if not provided
     */
  id: _propTypes.default.string,

  /**
     * Pass an EuiIcon, preferrably `size="l"`
     */

  /**
     * Pass an EuiIcon, preferrably `size="l"`
     */

  /**
     * Pass an EuiIcon, preferrably `size="l"`
     */
  children: _propTypes.default.node.isRequired,
  isDisabled: _propTypes.default.bool,

  /**
     * Indicate if an item is the current one.
     * Be sure to use `true` AND `false` when acting as a toggle to ensure the attribute is added for both states
     */

  /**
     * Indicate if an item is the current one.
     * Be sure to use `true` AND `false` when acting as a toggle to ensure the attribute is added for both states
     */

  /**
     * Indicate if an item is the current one.
     * Be sure to use `true` AND `false` when acting as a toggle to ensure the attribute is added for both states
     */
  isSelected: _propTypes.default.bool,

  /**
     * The text to display beneath the icon
     */

  /**
     * The text to display beneath the icon
     */

  /**
     * The text to display beneath the icon
     */
  label: _propTypes.default.node.isRequired,

  /**
     * Beta badges are unavailable if the item is checkable
     */

  /**
     * Beta badges are unavailable if the item is checkable
     */

  /**
         * Type `'multi'` renders the item as a `<label>` and
         * adds a checkbox.
         */

  /**
         * Type `'single'` renders the item as a `<label>` and
         * adds a radio element.
         */
  checkable: _propTypes.default.oneOfType([_propTypes.default.oneOfType([_propTypes.default.oneOf(["single"]).isRequired, _propTypes.default.oneOf(["multi"]).isRequired]).isRequired, _propTypes.default.oneOf([undefined])]),

  /**
         * The `name` attribute for radio inputs;
         * Required in order to group properly
         */
  name: _propTypes.default.string,

  /**
         * The value of the radio input for 'single'
         */
  value: _propTypes.default.string,

  /**
         * Multi: Returns the `id` of the clicked option
         */

  /**
         * Single: Returns the `id` of the clicked option and the `value`
         */
  onChange: _propTypes.default.func,
  href: _propTypes.default.string,
  onClick: _propTypes.default.func,
  buttonRef: _propTypes.default.any,
  rel: _propTypes.default.string,

  /**
     * Add a badge to the card to label it as "Beta" or other non-GA state
     */

  /**
     * Add a badge to the card to label it as "Beta" or other non-GA state
     */
  betaBadgeLabel: _propTypes.default.string,

  /**
     * Supply an icon type if the badge should just be an icon
     */
  betaBadgeIconType: _propTypes.default.oneOfType([_propTypes.default.oneOf(["accessibility", "addDataApp", "advancedSettingsApp", "agentApp", "aggregate", "alert", "analyzeEvent", "annotation", "apmApp", "apmTrace", "appSearchApp", "apps", "arrowDown", "arrowLeft", "arrowRight", "arrowUp", "asterisk", "auditbeatApp", "beaker", "bell", "bellSlash", "bolt", "boxesHorizontal", "boxesVertical", "branch", "broom", "brush", "bug", "bullseye", "calendar", "canvasApp", "check", "checkInCircleFilled", "cheer", "classificationJob", "clock", "cloudDrizzle", "cloudStormy", "cloudSunny", "codeApp", "color", "compute", "console", "consoleApp", "continuityAbove", "continuityAboveBelow", "continuityBelow", "continuityWithin", "controlsHorizontal", "controlsVertical", "copy", "copyClipboard", "createAdvancedJob", "createMultiMetricJob", "createPopulationJob", "createSingleMetricJob", "cross", "crossClusterReplicationApp", "crossInACircleFilled", "crosshairs", "currency", "cut", "dashboardApp", "dataVisualizer", "database", "devToolsApp", "discoverApp", "document", "documentEdit", "documentation", "documents", "dot", "download", "editorAlignCenter", "editorAlignLeft", "editorAlignRight", "editorBold", "editorCodeBlock", "editorComment", "editorDistributeHorizontal", "editorDistributeVertical", "editorHeading", "editorItalic", "editorItemAlignBottom", "editorItemAlignCenter", "editorItemAlignLeft", "editorItemAlignMiddle", "editorItemAlignRight", "editorItemAlignTop", "editorLink", "editorOrderedList", "editorPositionBottomLeft", "editorPositionBottomRight", "editorPositionTopLeft", "editorPositionTopRight", "editorRedo", "editorStrike", "editorTable", "editorUnderline", "editorUndo", "editorUnorderedList", "email", "empty", "emsApp", "eql", "eraser", "exit", "expand", "expandMini", "exportAction", "eye", "eyeClosed", "faceHappy", "faceNeutral", "faceSad", "filebeatApp", "filter", "flag", "fleetApp", "fold", "folderCheck", "folderClosed", "folderExclamation", "folderOpen", "frameNext", "framePrevious", "fullScreen", "fullScreenExit", "function", "gear", "gisApp", "glasses", "globe", "grab", "grabHorizontal", "graphApp", "grid", "grokApp", "heart", "heartbeatApp", "heatmap", "help", "home", "iInCircle", "image", "importAction", "indexClose", "indexEdit", "indexFlush", "indexManagementApp", "indexMapping", "indexOpen", "indexPatternApp", "indexRollupApp", "indexRuntime", "indexSettings", "inputOutput", "inspect", "invert", "ip", "keyboardShortcut", "kqlField", "kqlFunction", "kqlOperand", "kqlSelector", "kqlValue", "layers", "lensApp", "link", "list", "listAdd", "lock", "lockOpen", "logoAWS", "logoAWSMono", "logoAerospike", "logoApache", "logoAppSearch", "logoAzure", "logoAzureMono", "logoBeats", "logoBusinessAnalytics", "logoCeph", "logoCloud", "logoCloudEnterprise", "logoCode", "logoCodesandbox", "logoCouchbase", "logoDocker", "logoDropwizard", "logoElastic", "logoElasticStack", "logoElasticsearch", "logoEnterpriseSearch", "logoEtcd", "logoGCP", "logoGCPMono", "logoGithub", "logoGmail", "logoGolang", "logoGoogleG", "logoHAproxy", "logoIBM", "logoIBMMono", "logoKafka", "logoKibana", "logoKubernetes", "logoLogging", "logoLogstash", "logoMaps", "logoMemcached", "logoMetrics", "logoMongodb", "logoMySQL", "logoNginx", "logoObservability", "logoOsquery", "logoPhp", "logoPostgres", "logoPrometheus", "logoRabbitmq", "logoRedis", "logoSecurity", "logoSiteSearch", "logoSketch", "logoSlack", "logoUptime", "logoWebhook", "logoWindows", "logoWorkplaceSearch", "logsApp", "logstashFilter", "logstashIf", "logstashInput", "logstashOutput", "logstashQueue", "machineLearningApp", "magnet", "magnifyWithMinus", "magnifyWithPlus", "managementApp", "mapMarker", "memory", "menu", "menuDown", "menuLeft", "menuRight", "menuUp", "merge", "metricbeatApp", "metricsApp", "minimize", "minus", "minusInCircle", "minusInCircleFilled", "mobile", "monitoringApp", "moon", "nested", "node", "notebookApp", "number", "offline", "online", "outlierDetectionJob", "package", "packetbeatApp", "pageSelect", "pagesSelect", "paperClip", "partial", "pause", "pencil", "percent", "pin", "pinFilled", "pipelineApp", "play", "playFilled", "plus", "plusInCircle", "plusInCircleFilled", "popout", "push", "questionInCircle", "quote", "recentlyViewedApp", "refresh", "regressionJob", "reporter", "reportingApp", "returnKey", "save", "savedObjectsApp", "scale", "search", "searchProfilerApp", "securityAnalyticsApp", "securityApp", "securitySignal", "securitySignalDetected", "securitySignalResolved", "shard", "share", "snowflake", "sortDown", "sortLeft", "sortRight", "sortUp", "sortable", "spacesApp", "sqlApp", "starEmpty", "starEmptySpace", "starFilled", "starFilledSpace", "starMinusEmpty", "starMinusFilled", "starPlusEmpty", "starPlusFilled", "stats", "stop", "stopFilled", "stopSlash", "storage", "string", "submodule", "swatchInput", "symlink", "tableDensityCompact", "tableDensityExpanded", "tableDensityNormal", "tableOfContents", "tag", "tear", "temperature", "timeline", "timelionApp", "timeslider", "training", "trash", "unfold", "unlink", "upgradeAssistantApp", "uptimeApp", "user", "users", "usersRolesApp", "vector", "videoPlayer", "visArea", "visAreaStacked", "visBarHorizontal", "visBarHorizontalStacked", "visBarVertical", "visBarVerticalStacked", "visGauge", "visGoal", "visLine", "visMapCoordinate", "visMapRegion", "visMetric", "visPie", "visTable", "visTagCloud", "visText", "visTimelion", "visVega", "visVisualBuilder", "visualizeApp", "watchesApp", "wordWrap", "wordWrapDisabled", "workplaceSearchApp", "wrench", "tokenClass", "tokenProperty", "tokenEnum", "tokenVariable", "tokenMethod", "tokenAnnotation", "tokenException", "tokenInterface", "tokenParameter", "tokenField", "tokenElement", "tokenFunction", "tokenBoolean", "tokenString", "tokenArray", "tokenNumber", "tokenConstant", "tokenObject", "tokenEvent", "tokenKey", "tokenNull", "tokenStruct", "tokenPackage", "tokenOperator", "tokenEnumMember", "tokenRepo", "tokenSymbol", "tokenFile", "tokenModule", "tokenNamespace", "tokenDate", "tokenIP", "tokenNested", "tokenAlias", "tokenShape", "tokenGeo", "tokenRange", "tokenBinary", "tokenJoin", "tokenPercolator", "tokenFlattened", "tokenRankFeature", "tokenRankFeatures", "tokenKeyword", "tokenCompletionSuggester", "tokenDenseVector", "tokenText", "tokenTokenCount", "tokenSearchType", "tokenHistogram"]).isRequired, _propTypes.default.string.isRequired, _propTypes.default.elementType.isRequired]),

  /**
     * Add a description to the beta badge (will appear in a tooltip)
     */

  /**
     * Add a description to the beta badge (will appear in a tooltip)
     */
  betaBadgeTooltipContent: _propTypes.default.node
};