"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ValidationError = void 0;
var _ = require(".");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

class ValidationError extends _.SchemaError {
  static extractMessage(error, namespace, level) {
    const path = typeof namespace === 'string' ? [namespace, ...error.path] : error.path;
    let message = error.message;
    if (error instanceof _.SchemaTypesError) {
      const indentLevel = level || 0;
      const childErrorMessages = error.errors.map(childError => ValidationError.extractMessage(childError, namespace, indentLevel + 1));
      message = `${message}\n${childErrorMessages.map(childErrorMessage => `${' '.repeat(indentLevel)}- ${childErrorMessage}`).join('\n')}`;
    }
    if (path.length === 0) {
      return message;
    }
    return `[${path.join('.')}]: ${message}`;
  }
  constructor(error, namespace) {
    super(ValidationError.extractMessage(error, namespace), error);

    // https://github.com/Microsoft/TypeScript/wiki/Breaking-Changes#extending-built-ins-like-error-array-and-map-may-no-longer-work
    Object.setPrototypeOf(this, ValidationError.prototype);
  }
}
exports.ValidationError = ValidationError;