"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConditionalType = void 0;
var _typeDetect = _interopRequireDefault(require("type-detect"));
var _internals = require("../internals");
var _references = require("../references");
var _type = require("./type");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

class ConditionalType extends _type.Type {
  constructor(leftOperand, rightOperand, equalType, notEqualType, options) {
    const schema = _internals.internals.when(leftOperand.getSchema(), {
      is: _references.Reference.isReference(rightOperand) || rightOperand instanceof _type.Type ? rightOperand.getSchema() : rightOperand,
      then: equalType.getSchema(),
      otherwise: notEqualType.getSchema()
    });
    super(schema, options);
  }
  handleError(type, {
    value
  }) {
    if (type === 'any.required') {
      return `expected at least one defined value but got [${(0, _typeDetect.default)(value)}]`;
    }
  }
}
exports.ConditionalType = ConditionalType;