"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LegacyObjectToConfigAdapter = void 0;
var _object_to_config_adapter = require("../object_to_config_adapter");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * Represents logging config supported by the legacy platform.
 */

/**
 * Represents adapter between config provided by legacy platform and `Config`
 * supported by the current platform.
 * @internal
 */
class LegacyObjectToConfigAdapter extends _object_to_config_adapter.ObjectToConfigAdapter {
  static transformLogging(configValue = {}) {
    const {
      appenders,
      root,
      loggers,
      ...legacyLoggingConfig
    } = configValue;
    const loggingConfig = {
      appenders: {
        ...appenders,
        default: {
          type: 'legacy-appender',
          legacyLoggingConfig
        }
      },
      root: {
        level: 'info',
        ...root
      },
      loggers,
      ...legacyLoggingConfig
    };
    if (configValue.silent) {
      loggingConfig.root.level = 'off';
    } else if (configValue.quiet) {
      loggingConfig.root.level = 'error';
    } else if (configValue.verbose) {
      loggingConfig.root.level = 'all';
    }
    return loggingConfig;
  }
  get(configPath) {
    const configValue = super.get(configPath);
    switch (configPath) {
      case 'logging':
        return LegacyObjectToConfigAdapter.transformLogging(configValue);
      default:
        return configValue;
    }
  }
}
exports.LegacyObjectToConfigAdapter = LegacyObjectToConfigAdapter;