"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.deepExactRt = deepExactRt;
var t = _interopRequireWildcard(require("io-ts"));
var _lodash = require("lodash");
var _merge_rt = require("../merge_rt");
var _parseable_types = require("../parseable_types");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function deepExactRt(type) {
  if (!(0, _parseable_types.isParsableType)(type)) {
    return type;
  }
  switch (type._tag) {
    case 'ArrayType':
      return t.array(deepExactRt(type.type));
    case 'DictionaryType':
      return t.dictionary(type.domain, deepExactRt(type.codomain));
    case 'InterfaceType':
      return t.exact(t.interface((0, _lodash.mapValues)(type.props, deepExactRt)));
    case 'PartialType':
      return t.exact(t.partial((0, _lodash.mapValues)(type.props, deepExactRt)));
    case 'IntersectionType':
      return t.intersection(type.types.map(deepExactRt));
    case 'UnionType':
      return t.union(type.types.map(deepExactRt));
    case 'MergeType':
      return (0, _merge_rt.mergeRt)(deepExactRt(type.types[0]), deepExactRt(type.types[1]));
    default:
      return type;
  }
}