"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.threat_query = exports.threat_mapping = exports.threat_language = exports.threat_indicator_path = exports.threat_index = exports.threat_filters = exports.threatQueryOrUndefined = exports.threatMappingOrUndefined = exports.threatMappingEntries = exports.threatMapEntry = exports.threatMap = exports.threatLanguageOrUndefined = exports.threatIndicatorPathOrUndefined = exports.threatIndexOrUndefined = exports.threatFiltersOrUndefined = exports.items_per_search = exports.itemsPerSearchOrUndefined = exports.concurrent_searches = exports.concurrentSearchesOrUndefined = void 0;
var t = _interopRequireWildcard(require("io-ts"));
var _securitysolutionIoTsTypes = require("@kbn/securitysolution-io-ts-types");
var _language = require("../language");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/* eslint-disable @typescript-eslint/naming-convention */

const threat_query = exports.threat_query = t.string;
const threatQueryOrUndefined = exports.threatQueryOrUndefined = t.union([threat_query, t.undefined]);
const threat_indicator_path = exports.threat_indicator_path = t.string;
const threatIndicatorPathOrUndefined = exports.threatIndicatorPathOrUndefined = t.union([threat_indicator_path, t.undefined]);
const threat_filters = exports.threat_filters = t.array(t.unknown); // Filters are not easily type-able yet

const threatFiltersOrUndefined = exports.threatFiltersOrUndefined = t.union([threat_filters, t.undefined]);
const threatMapEntry = exports.threatMapEntry = t.exact(t.type({
  field: _securitysolutionIoTsTypes.NonEmptyString,
  type: t.keyof({
    mapping: null
  }),
  value: _securitysolutionIoTsTypes.NonEmptyString
}));
const threatMappingEntries = exports.threatMappingEntries = t.array(threatMapEntry);
const threatMap = exports.threatMap = t.exact(t.type({
  entries: threatMappingEntries
}));
const threat_mapping = exports.threat_mapping = (0, _securitysolutionIoTsTypes.NonEmptyArray)(threatMap, 'NonEmptyArray<ThreatMap>');
const threatMappingOrUndefined = exports.threatMappingOrUndefined = t.union([threat_mapping, t.undefined]);
const threat_index = exports.threat_index = t.array(t.string);
const threatIndexOrUndefined = exports.threatIndexOrUndefined = t.union([threat_index, t.undefined]);
const threat_language = exports.threat_language = t.union([_language.language, t.undefined]);
const threatLanguageOrUndefined = exports.threatLanguageOrUndefined = t.union([threat_language, t.undefined]);
const concurrent_searches = exports.concurrent_searches = _securitysolutionIoTsTypes.PositiveIntegerGreaterThanZero;
const concurrentSearchesOrUndefined = exports.concurrentSearchesOrUndefined = t.union([concurrent_searches, t.undefined]);
const items_per_search = exports.items_per_search = _securitysolutionIoTsTypes.PositiveIntegerGreaterThanZero;
const itemsPerSearchOrUndefined = exports.itemsPerSearchOrUndefined = t.union([items_per_search, t.undefined]);